/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.book.Book;

public class PageQuest
extends PageWithText {
    ResourceLocation trigger;
    String title;
    transient boolean isManual;

    @Override
    public int getTextHeight() {
        return 22;
    }

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.isManual = this.trigger == null;
    }

    public boolean isCompleted(Book book) {
        return this.isManual ? PersistentData.data.getBookData((Book)book).completedManualQuests.contains(this.entry.getId().toString()) : this.trigger != null && ClientAdvancements.hasDone(this.trigger.toString());
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.isManual) {
            Button button = new Button(8, 121, 100, 20, StringTextComponent.field_240750_d_, this::questButtonClicked);
            this.addButton(button);
            this.updateButtonText(button);
        }
    }

    private void updateButtonText(Button button) {
        boolean completed = this.isCompleted(this.parent.book);
        TranslationTextComponent s = new TranslationTextComponent(completed ? "patchouli.gui.lexicon.mark_incomplete" : "patchouli.gui.lexicon.mark_complete");
        button.func_238482_a_((ITextComponent)s);
    }

    protected void questButtonClicked(Button button) {
        String res = this.entry.getId().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.parent.book);
        if (data.completedManualQuests.contains(res)) {
            data.completedManualQuests.remove(res);
        } else {
            data.completedManualQuests.add(res);
        }
        PersistentData.save();
        this.updateButtonText(button);
        this.entry.markReadStateDirty();
    }

    @Override
    public void render(MatrixStack ms, int mouseX, int mouseY, float pticks) {
        super.render(ms, mouseX, mouseY, pticks);
        this.parent.drawCenteredStringNoShadow(ms, this.title == null || this.title.isEmpty() ? I18n.func_135052_a((String)"patchouli.gui.lexicon.objective", (Object[])new Object[0]) : this.i18n(this.title), 58, 0, this.book.headerColor);
        GuiBook.drawSeparator(ms, this.book, 0, 12);
        if (!this.isManual) {
            GuiBook.drawSeparator(ms, this.book, 0, 131);
            boolean completed = this.isCompleted(this.parent.book);
            String s = I18n.func_135052_a((String)(completed ? "patchouli.gui.lexicon.complete" : "patchouli.gui.lexicon.incomplete"), (Object[])new Object[0]);
            int color = completed ? 35610 : this.book.headerColor;
            this.parent.drawCenteredStringNoShadow(ms, s, 58, 139, color);
        }
    }
}

