/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IceBlock;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonHooks;

@Mod.EventBusSubscriber
public class RandomUpdateHandler {
    private void adjustWeatherFrequency(World world, Season season) {
        if (!((Boolean)SeasonsConfig.changeWeatherFrequency.get()).booleanValue()) {
            return;
        }
        IServerWorldInfo serverLevelData = (IServerWorldInfo)world.func_72912_H();
        if (season == Season.WINTER) {
            if (serverLevelData.func_76061_m()) {
                serverLevelData.func_76069_a(false);
            }
            if (!world.func_72912_H().func_76059_o() && serverLevelData.func_76083_p() > 36000) {
                serverLevelData.func_76080_g(world.field_73012_v.nextInt(24000) + 12000);
            }
        } else if (season == Season.SPRING) {
            if (!world.func_72912_H().func_76059_o() && serverLevelData.func_76083_p() > 96000) {
                serverLevelData.func_76080_g(world.field_73012_v.nextInt(84000) + 12000);
            }
        } else if (season == Season.SUMMER && !world.func_72912_H().func_76061_m() && serverLevelData.func_76071_n() > 36000) {
            serverLevelData.func_76090_f(world.field_73012_v.nextInt(24000) + 12000);
        }
    }

    private void meltInChunk(ChunkManager chunkManager, Chunk chunkIn, Season.SubSeason subSeason) {
        int meltRand;
        ServerWorld world = chunkManager.field_219255_i;
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.func_180334_c();
        int j = chunkpos.func_180333_d();
        switch (subSeason) {
            case EARLY_SPRING: {
                meltRand = 16;
                break;
            }
            case MID_SPRING: {
                meltRand = 12;
                break;
            }
            case LATE_SPRING: {
                meltRand = 8;
                break;
            }
            default: {
                meltRand = 4;
            }
        }
        if (world.field_73012_v.nextInt(meltRand) == 0) {
            BlockPos topAirPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(i, 0, j, 15));
            BlockPos topGroundPos = topAirPos.func_177977_b();
            BlockState aboveGroundState = world.func_180495_p(topAirPos);
            BlockState groundState = world.func_180495_p(topGroundPos);
            RegistryKey biome = world.func_242406_i(topAirPos).orElse(null);
            if (!BiomeConfig.enablesSeasonalEffects((RegistryKey<Biome>)biome)) {
                return;
            }
            if (aboveGroundState.func_177230_c() == Blocks.field_150433_aE) {
                if (SeasonHooks.getBiomeTemperature((World)world, (RegistryKey<Biome>)biome, topGroundPos) >= 0.15f) {
                    world.func_175656_a(topAirPos, Blocks.field_150350_a.func_176223_P());
                }
            } else if (groundState.func_177230_c() == Blocks.field_150432_aD && SeasonHooks.getBiomeTemperature((World)world, (RegistryKey<Biome>)biome, topGroundPos) >= 0.15f) {
                ((IceBlock)Blocks.field_150432_aD).func_196454_d(groundState, (World)world, topGroundPos);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            Season.SubSeason subSeason = SeasonHelper.getSeasonState(event.world).getSubSeason();
            Season season = subSeason.getSeason();
            this.adjustWeatherFrequency(event.world, season);
            if (season != Season.WINTER && ((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() && SeasonsConfig.isDimensionWhitelisted((RegistryKey<World>)event.world.func_234923_W_())) {
                ServerWorld world = (ServerWorld)event.world;
                ChunkManager chunkManager = world.func_72863_F().field_217237_a;
                chunkManager.func_223491_f().forEach(chunkHolder -> {
                    Optional optional = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                    if (optional.isPresent()) {
                        Chunk chunk = (Chunk)optional.get();
                        ChunkPos chunkpos = chunkHolder.func_219277_h();
                        if (!chunkManager.func_219243_d(chunkpos)) {
                            this.meltInChunk(chunkManager, chunk, subSeason);
                        }
                    }
                });
            }
        }
    }
}

