/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.HashMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import sereneseasons.core.SereneSeasons;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;

public class TimeSkipHandler {
    public static final HashMap<RegistryKey<World>, Long> lastDayTimes = new HashMap();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
            long lastDayTime;
            long difference;
            ServerWorld world = (ServerWorld)event.world;
            long dayTime = world.func_72912_H().func_76073_f();
            if (!lastDayTimes.containsKey(world.func_234923_W_())) {
                lastDayTimes.put((RegistryKey<World>)world.func_234923_W_(), dayTime);
            }
            if ((difference = dayTime - (lastDayTime = lastDayTimes.get(world.func_234923_W_()).longValue())) < 0L) {
                difference += 24000L;
            }
            if (difference > 1L) {
                SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((World)world);
                seasonData.seasonCycleTicks = (int)((long)seasonData.seasonCycleTicks + difference);
                seasonData.func_76185_a();
                SeasonHandler.sendSeasonUpdate((World)world);
                SereneSeasons.logger.info("Season time skipped by " + difference + " in " + world.func_234923_W_().func_240901_a_().toString());
            }
            lastDayTimes.put((RegistryKey<World>)world.func_234923_W_(), dayTime);
        }
    }
}

