/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import sereneseasons.api.config.ISyncedOption;
import sereneseasons.api.config.SeasonsOption;
import sereneseasons.api.config.SyncedConfig;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.FertilityConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.core.SereneSeasons;

public class ModConfig {
    public static void init() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "sereneseasons");
        try {
            Files.createDirectory(modConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            SereneSeasons.logger.error("Failed to create sereneseasons config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FertilityConfig.SPEC, "sereneseasons/fertility.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SeasonsConfig.SPEC, "sereneseasons/seasons.toml");
        BiomeConfig.init(modConfigPath.toFile());
    }

    public static void setup() {
        ModConfig.addSyncedValue(SeasonsOption.DAY_DURATION, SeasonsConfig.dayDuration.get());
        ModConfig.addSyncedValue(SeasonsOption.SUB_SEASON_DURATION, SeasonsConfig.subSeasonDuration.get());
        ModConfig.addSyncedValue(SeasonsOption.STARTING_SUB_SEASON, SeasonsConfig.startingSubSeason.get());
        ModConfig.addSyncedValue(SeasonsOption.PROGRESS_SEASON_WHILE_OFFLINE, SeasonsConfig.progressSeasonWhileOffline.get());
    }

    private static <T> void addSyncedValue(ISyncedOption option, T defaultValue) {
        SyncedConfig.addOption(option, defaultValue.toString());
    }
}

