/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.network.message;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sereneseasons.api.config.SyncedConfig;
import sereneseasons.core.SereneSeasons;

public class MessageSyncConfigs {
    public CompoundNBT nbtOptions;

    public MessageSyncConfigs(CompoundNBT nbtOptions) {
        this.nbtOptions = nbtOptions;
    }

    public static void encode(MessageSyncConfigs packet, PacketBuffer buf) {
        buf.func_150786_a(packet.nbtOptions);
    }

    public static MessageSyncConfigs decode(PacketBuffer buf) {
        return new MessageSyncConfigs(buf.func_150793_b());
    }

    public static class Handler {
        public static void handle(MessageSyncConfigs packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                for (String key : packet.nbtOptions.func_150296_c()) {
                    SyncedConfig.SyncedConfigEntry entry = SyncedConfig.optionsToSync.get(key);
                    if (entry == null) {
                        SereneSeasons.logger.error("Option " + key + " does not exist locally!");
                    }
                    entry.value = packet.nbtOptions.func_74779_i(key);
                    SereneSeasons.logger.info("SS configuration synchronized with the server");
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

