/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.elements;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

@OnlyIn(value=Dist.CLIENT)
public class PageIconLinkElement
extends SizedBookElement {
    public PageData pageData;
    public SizedBookElement displayElement;
    public TextData link;
    public String action;
    public ITextComponent name;

    public PageIconLinkElement(int x, int y, SizedBookElement displayElement, ITextComponent name, PageData pageData) {
        this(x, y, displayElement.width, displayElement.height, displayElement, name, pageData);
    }

    public PageIconLinkElement(int x, int y, int w, int h, SizedBookElement displayElement, ITextComponent name, PageData pageData) {
        super(x, y, w, h);
        this.displayElement = displayElement;
        this.pageData = pageData;
        this.action = "go-to-page-rtn:" + pageData.parent.name + "." + pageData.name;
        this.name = name;
    }

    public void draw(MatrixStack matrices, int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        boolean hover = this.isHovered(mouseX, mouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(hover ? 1.0f : 0.5f));
        if (this.isHovered(mouseX, mouseY)) {
            PageIconLinkElement.func_238467_a_((MatrixStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(this.parent.book.appearance.hoverColor | 0x77000000));
        }
        this.displayElement.draw(matrices, mouseX, mouseY, partialTicks, fontRenderer);
    }

    public void drawOverlay(MatrixStack matrices, int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        if (this.name != null && !this.name.getString().isEmpty() && this.isHovered(mouseX, mouseY)) {
            this.drawHoveringText(matrices, (List)ImmutableList.of((Object)this.name), mouseX, mouseY, fontRenderer);
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isHovered(mouseX, mouseY)) {
            StringActionProcessor.process((String)this.action, (BookScreen)this.parent);
        }
    }
}

