/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.library.client.RenderUtils;

public final class GuiUtil {
    public static void drawBackground(MatrixStack matrices, ContainerScreen<?> screen, ResourceLocation background) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.getMinecraft().func_110434_K().func_110577_a(background);
        screen.func_238474_b_(matrices, screen.field_147003_i, screen.field_147009_r, 0, 0, screen.field_146999_f, screen.field_147000_g);
    }

    public static void drawContainerNames(MatrixStack matrices, ContainerScreen<?> screen, FontRenderer font, PlayerInventory inv) {
        String name = screen.func_231171_q_().getString();
        font.func_238421_b_(matrices, name, (float)screen.field_146999_f / 2.0f - (float)font.func_78256_a(name) / 2.0f, 6.0f, 0x404040);
        font.func_238421_b_(matrices, inv.func_145748_c_().getString(), 8.0f, (float)(screen.field_147000_g - 96 + 2), 0x404040);
    }

    public static boolean isHovered(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public static boolean isTankHovered(int mouseX, int mouseY, int amount, int capacity, int x, int y, int width, int height) {
        if (mouseX < x || mouseX > x + width || mouseY > y + height) {
            return false;
        }
        int topHeight = height - height * amount / capacity;
        return mouseY > y + topHeight;
    }

    public static void renderFluidTank(MatrixStack matrices, ContainerScreen<?> screen, FluidStack stack, int capacity, int x, int y, int width, int height, int depth) {
        GuiUtil.renderFluidTank(matrices, screen, stack, stack.getAmount(), capacity, x, y, width, height, depth);
    }

    public static void renderFluidTank(MatrixStack matrices, ContainerScreen<?> screen, FluidStack stack, int amount, int capacity, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty()) {
            int maxY = y + height;
            int fluidHeight = Math.min(height * amount / capacity, height);
            GuiUtil.renderTiledFluid(matrices, screen, stack, x, maxY - fluidHeight, width, fluidHeight, depth);
        }
    }

    public static void renderTiledFluid(MatrixStack matrices, ContainerScreen<?> screen, FluidStack stack, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty()) {
            TextureAtlasSprite fluidSprite = (TextureAtlasSprite)screen.getMinecraft().func_228015_a_(PlayerContainer.field_226615_c_).apply(stack.getFluid().getAttributes().getStillTexture(stack));
            RenderUtils.setColorRGBA(stack.getFluid().getAttributes().getColor(stack));
            GuiUtil.renderTiledTextureAtlas(matrices, screen, fluidSprite, x, y, width, height, depth, stack.getFluid().getAttributes().isGaseous(stack));
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderTiledTextureAtlas(MatrixStack matrices, ContainerScreen<?> screen, TextureAtlasSprite sprite, int x, int y, int width, int height, int depth, boolean upsideDown) {
        screen.getMinecraft().func_110434_K().func_110577_a(sprite.func_229241_m_().func_229223_g_());
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        int spriteHeight = sprite.func_94216_b();
        int spriteWidth = sprite.func_94211_a();
        int startX = x + screen.field_147003_i;
        int startY = y + screen.field_147009_r;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.func_94207_b((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            int x2 = startX;
            int widthLeft = width;
            Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
            do {
                int renderWidth = Math.min(spriteWidth, widthLeft);
                widthLeft -= renderWidth;
                float u2 = sprite.func_94214_a((double)(16.0f * (float)renderWidth / (float)spriteWidth));
                if (upsideDown) {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v2, v1);
                } else {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v1, v2);
                }
                x2 += renderWidth;
            } while (widthLeft > 0);
            startY += renderHeight;
        } while (height > 0);
        builder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
    }

    private static void buildSquare(Matrix4f matrix, BufferBuilder builder, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        builder.func_227888_a_(matrix, (float)x1, (float)y2, (float)z).func_225583_a_(u1, v2).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, (float)z).func_225583_a_(u2, v2).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y1, (float)z).func_225583_a_(u2, v1).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y1, (float)z).func_225583_a_(u1, v1).func_181675_d();
    }

    public static void drawProgressUp(MatrixStack matrices, ElementScreen element, int x, int y, float progress) {
        int height = progress > 1.0f ? element.h : (progress < 0.0f ? 0 : (int)((double)(progress * (float)element.h) + 0.5));
        int deltaY = element.h - height;
        Screen.func_238463_a_((MatrixStack)matrices, (int)x, (int)(y + deltaY), (float)element.x, (float)(element.y + deltaY), (int)element.w, (int)height, (int)element.texW, (int)element.texH);
    }

    public static void renderHighlight(MatrixStack matrices, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        AbstractGui.func_238467_a_((MatrixStack)matrices, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    private GuiUtil() {
    }
}

