/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.traits;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.materials.json.MaterialTraitsJson;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public class MaterialTraits {
    private final List<ModifierEntry> defaultTraits;
    private final Map<MaterialStatsId, List<ModifierEntry>> traitsPerStats;

    public boolean hasUniqueTraits(MaterialStatsId statsId) {
        return this.traitsPerStats.containsKey((Object)statsId);
    }

    public List<ModifierEntry> getTraits(MaterialStatsId statsId) {
        return this.traitsPerStats.getOrDefault((Object)statsId, this.defaultTraits);
    }

    public void write(PacketBuffer buffer) {
        MaterialTraits.writeTraitList(buffer, this.defaultTraits);
        buffer.func_150787_b(this.traitsPerStats.size());
        for (Map.Entry<MaterialStatsId, List<ModifierEntry>> entry : this.traitsPerStats.entrySet()) {
            buffer.func_192572_a((ResourceLocation)entry.getKey());
            MaterialTraits.writeTraitList(buffer, entry.getValue());
        }
    }

    public static MaterialTraits read(PacketBuffer buffer) {
        List<ModifierEntry> defaultTraits = MaterialTraits.readTraitList(buffer);
        int statTypeCount = buffer.func_150792_a();
        HashMap<MaterialStatsId, List<ModifierEntry>> statsTraits = new HashMap<MaterialStatsId, List<ModifierEntry>>(statTypeCount);
        for (int i = 0; i < statTypeCount; ++i) {
            MaterialStatsId statsId = new MaterialStatsId(buffer.func_192575_l());
            List<ModifierEntry> traitsList = MaterialTraits.readTraitList(buffer);
            statsTraits.put(statsId, traitsList);
        }
        return new MaterialTraits(defaultTraits, statsTraits);
    }

    private static List<ModifierEntry> readTraitList(PacketBuffer buffer) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            builder.add((Object)ModifierEntry.read(buffer));
        }
        return builder.build();
    }

    private static void writeTraitList(PacketBuffer buffer, List<ModifierEntry> traits) {
        buffer.func_150787_b(traits.size());
        for (ModifierEntry entry : traits) {
            entry.write(buffer);
        }
    }

    public MaterialTraits(List<ModifierEntry> defaultTraits, Map<MaterialStatsId, List<ModifierEntry>> traitsPerStats) {
        this.defaultTraits = defaultTraits;
        this.traitsPerStats = traitsPerStats;
    }

    public List<ModifierEntry> getDefaultTraits() {
        return this.defaultTraits;
    }

    protected Map<MaterialStatsId, List<ModifierEntry>> getTraitsPerStats() {
        return this.traitsPerStats;
    }

    public static class Builder {
        private List<ModifierEntry> defaultTraits = null;
        private final Map<MaterialStatsId, List<ModifierEntry>> traitsPerStats = new HashMap<MaterialStatsId, List<ModifierEntry>>();

        public void setDefaultTraits(@Nullable List<ModifierEntry> traits) {
            if (traits != null) {
                this.defaultTraits = traits;
            }
        }

        public void setTraits(MaterialStatsId statsId, @Nullable List<ModifierEntry> traits) {
            if (traits != null) {
                this.traitsPerStats.put(statsId, traits);
            } else {
                this.traitsPerStats.remove((Object)statsId);
            }
        }

        public MaterialTraitsJson serialize() {
            HashMap newMap = null;
            if (!this.traitsPerStats.isEmpty()) {
                newMap = new HashMap(this.traitsPerStats.size());
                this.traitsPerStats.forEach(newMap::put);
            }
            return new MaterialTraitsJson(this.defaultTraits, newMap);
        }

        public MaterialTraits build() {
            List<ModifierEntry> defaultTraits = this.defaultTraits;
            if (defaultTraits == null || defaultTraits.isEmpty()) {
                defaultTraits = Collections.emptyList();
            }
            ImmutableMap traitsPerStats = this.traitsPerStats.isEmpty() ? Collections.emptyMap() : ImmutableMap.copyOf(this.traitsPerStats);
            return new MaterialTraits(defaultTraits, (Map<MaterialStatsId, List<ModifierEntry>>)traitsPerStats);
        }

        public List<ModifierEntry> getDefaultTraits() {
            return this.defaultTraits;
        }

        protected Map<MaterialStatsId, List<ModifierEntry>> getTraitsPerStats() {
            return this.traitsPerStats;
        }
    }
}

