/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public interface IDisplayModifierRecipe
extends IModifierRecipe {
    public static final Function<Item, ItemStack> MAP_TOOL_FOR_RENDERING = IModifiableDisplay::getDisplayStack;

    public List<List<ItemStack>> getDisplayItems();

    public List<ItemStack> getToolWithModifier();

    public ModifierEntry getDisplayResult();

    @Override
    default public Modifier getModifier() {
        return this.getDisplayResult().getModifier();
    }

    default public int getMaxLevel() {
        return 0;
    }

    @Nullable
    default public SlotType.SlotCount getSlots() {
        return null;
    }

    @Override
    @Nullable
    default public SlotType getSlotType() {
        SlotType.SlotCount count = this.getSlots();
        if (count == null) {
            return null;
        }
        return count.getType();
    }

    default public boolean hasRequirements() {
        return false;
    }

    default public String getRequirementsError() {
        return "";
    }

    default public boolean isIncremental() {
        return false;
    }

    default public int getUpgradeSlots() {
        return SlotType.SlotCount.get(this.getSlots(), SlotType.UPGRADE);
    }

    default public int getAbilitySlots() {
        return SlotType.SlotCount.get(this.getSlots(), SlotType.ABILITY);
    }

    public static Stream<Item> getAllModifiable() {
        return TinkerTags.Items.MODIFIABLE.func_230236_b_().stream();
    }

    public static ItemStack withModifiers(ItemStack stack, @Nullable ModifierMatch match, @Nullable ModifierEntry newModifier) {
        return IDisplayModifierRecipe.withModifiers(stack, match, newModifier, data -> {});
    }

    public static ItemStack withModifiers(ItemStack stack, @Nullable ModifierMatch match, @Nullable ModifierEntry newModifier, Consumer<ModDataNBT> persistentDataConsumer) {
        ItemStack output = stack.func_77946_l();
        CompoundNBT nbt = output.func_196082_o();
        ModifierNBT.Builder builder = ModifierNBT.builder();
        if (match != null) {
            match.apply(builder);
        }
        if (newModifier != null) {
            builder.add(newModifier);
        }
        ModifierNBT modifiers = builder.build();
        ListNBT list = modifiers.serializeToNBT();
        nbt.func_218657_a("tic_upgrades", (INBT)list);
        nbt.func_218657_a("tic_modifiers", (INBT)list);
        CompoundNBT persistentNBT = new CompoundNBT();
        ModDataNBT persistentData = ModDataNBT.readFromNBT(persistentNBT);
        CompoundNBT volatileNBT = new CompoundNBT();
        ModDataNBT volatileData = ModDataNBT.readFromNBT(volatileNBT);
        persistentDataConsumer.accept(persistentData);
        for (ModifierEntry entry : modifiers.getModifiers()) {
            entry.getModifier().addVolatileData(stack.func_77973_b(), ToolDefinition.EMPTY, StatsNBT.EMPTY, persistentData, entry.getLevel(), volatileData);
        }
        nbt.func_218657_a("tic_volatile_data", (INBT)volatileNBT);
        nbt.func_218657_a("tic_persistent_data", (INBT)persistentNBT);
        return output;
    }
}

