/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.SpecializedRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.TinkerStationRepairRecipe;

public class SpecializedRepairRecipe
extends TinkerStationRepairRecipe
implements SpecializedRepairRecipeSerializer.ISpecializedRepairRecipe {
    private final Ingredient tool;
    private final MaterialId repairMaterialID;
    private IMaterial repairMaterial;

    public SpecializedRepairRecipe(ResourceLocation id, Ingredient tool, MaterialId repairMaterialID) {
        super(id);
        this.tool = tool;
        this.repairMaterialID = repairMaterialID;
    }

    private IMaterial getRepairMaterial() {
        if (this.repairMaterial == null) {
            this.repairMaterial = MaterialRegistry.getMaterial(this.repairMaterialID);
        }
        return this.repairMaterial;
    }

    @Override
    protected IMaterial getPrimaryMaterial(IModifierToolStack tool) {
        return this.getRepairMaterial();
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        IMaterial repairMaterial = this.getRepairMaterial();
        if (!this.tool.test(tinkerable) || repairMaterial == IMaterial.UNKNOWN) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            IMaterial inputMaterial = TinkerStationRepairRecipe.getMaterialFrom(inv, i);
            if (inputMaterial != repairMaterial) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.specializedRepairSerializer.get();
    }

    @Override
    public Ingredient getTool() {
        return this.tool;
    }

    @Override
    public MaterialId getRepairMaterialID() {
        return this.repairMaterialID;
    }
}

