/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public abstract class PartRequirement {
    public static final Serializer SERIALIZER = new Serializer();
    private final int weight;

    public static PartRequirement ofPart(IToolPart part, int weight) {
        return new ToolPart(part, weight);
    }

    public static PartRequirement ofStat(MaterialStatsId statsId, int weight) {
        return new StatType(statsId, weight);
    }

    @Nullable
    public abstract IToolPart getPart();

    public abstract boolean matches(Item var1);

    public abstract boolean canUseMaterial(IMaterial var1);

    public abstract ITextComponent nameForMaterial(IMaterial var1);

    public abstract MaterialStatsId getStatType();

    public abstract void write(PacketBuffer var1);

    public abstract JsonObject serialize();

    public static PartRequirement read(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            IToolPart part = (IToolPart)RecipeHelper.readItem((PacketBuffer)buffer, IToolPart.class);
            int weight = buffer.func_150792_a();
            return PartRequirement.ofPart(part, weight);
        }
        MaterialStatsId statsId = new MaterialStatsId(buffer.func_192575_l());
        int weight = buffer.func_150792_a();
        return PartRequirement.ofStat(statsId, weight);
    }

    public PartRequirement(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartRequirement)) {
            return false;
        }
        PartRequirement other = (PartRequirement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getWeight() == other.getWeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartRequirement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeight();
        return result;
    }

    public String toString() {
        return "PartRequirement(weight=" + this.getWeight() + ")";
    }

    private static class StatType
    extends PartRequirement {
        private final MaterialStatsId statType;

        public StatType(MaterialStatsId statType, int weight) {
            super(weight);
            this.statType = statType;
        }

        @Override
        @Nullable
        public IToolPart getPart() {
            return null;
        }

        @Override
        public boolean matches(Item item) {
            return false;
        }

        @Override
        public boolean canUseMaterial(IMaterial material) {
            return MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), this.statType).isPresent();
        }

        @Override
        public ITextComponent nameForMaterial(IMaterial material) {
            return material.getDisplayName();
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeBoolean(false);
            buffer.func_192572_a((ResourceLocation)this.statType);
            buffer.func_150787_b(this.getWeight());
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("stat", this.statType.toString());
            if (this.getWeight() != 1) {
                jsonObject.addProperty("weight", (Number)this.getWeight());
            }
            return jsonObject;
        }

        @Override
        public MaterialStatsId getStatType() {
            return this.statType;
        }
    }

    private static class ToolPart
    extends PartRequirement {
        private final IToolPart part;

        public ToolPart(IToolPart part, int weight) {
            super(weight);
            this.part = part;
        }

        @Override
        public boolean matches(Item item) {
            return this.part.func_199767_j() == item;
        }

        @Override
        public boolean canUseMaterial(IMaterial material) {
            return this.part.canUseMaterial(material);
        }

        @Override
        public ITextComponent nameForMaterial(IMaterial material) {
            return this.part.withMaterial(material).func_200301_q();
        }

        @Override
        public MaterialStatsId getStatType() {
            return this.part.getStatType();
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.writeBoolean(true);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)this.part);
            buffer.func_150787_b(this.getWeight());
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(this.part.func_199767_j().getRegistryName()).toString());
            if (this.getWeight() != 1) {
                jsonObject.addProperty("weight", (Number)this.getWeight());
            }
            return jsonObject;
        }

        @Override
        public IToolPart getPart() {
            return this.part;
        }
    }

    protected static class Serializer
    implements JsonDeserializer<PartRequirement>,
    JsonSerializer<PartRequirement> {
        protected Serializer() {
        }

        public PartRequirement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JSONUtils.func_151210_l((JsonElement)json, (String)"part");
            int weight = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"weight", (int)1);
            if (jsonObject.has("item")) {
                ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"item");
                if (!ForgeRegistries.ITEMS.containsKey(name)) {
                    throw new JsonSyntaxException("Invalid item '" + name + "' for tool part, does not exist");
                }
                Item item = (Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(name));
                if (!(item instanceof IToolPart)) {
                    throw new JsonSyntaxException("Invalid item '" + name + "' for tool part, must implement IToolPart");
                }
                return PartRequirement.ofPart((IToolPart)item, weight);
            }
            if (jsonObject.has("stat")) {
                MaterialStatsId stat = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"stat"));
                return PartRequirement.ofStat(stat, weight);
            }
            throw new JsonSyntaxException("Invalid part, must have either 'item' or 'stat'");
        }

        public JsonElement serialize(PartRequirement part, Type typeOfSrc, JsonSerializationContext context) {
            return part.serialize();
        }
    }
}

