/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialItem
extends Item
implements IMaterialItem {
    private static final String ADDED_BY = TConstruct.makeTranslationKey("tooltip", "part.added_by");

    public MaterialItem(Item.Properties properties) {
        super(properties);
    }

    private static Optional<MaterialId> getMaterialId(@Nullable CompoundNBT nbt) {
        return Optional.ofNullable(nbt).map(compoundNBT -> compoundNBT.func_74779_i("Material")).filter(string -> !string.isEmpty()).map(MaterialId::tryCreate);
    }

    @Override
    public Optional<MaterialId> getMaterialId(ItemStack stack) {
        return MaterialItem.getMaterialId(stack.func_77978_p());
    }

    @Override
    public ItemStack withMaterialForDisplay(MaterialId materialId) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        stack.func_196082_o().func_74778_a("Material", materialId.toString());
        return stack;
    }

    @Override
    public ItemStack withMaterial(IMaterial material) {
        if (this.canUseMaterial(material)) {
            return this.withMaterialForDisplay(material.getIdentifier());
        }
        return new ItemStack((IItemProvider)this);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && MaterialRegistry.isFullyLoaded()) {
            IMaterial material2;
            MaterialId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyPartMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryCreate(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && !material2.isHidden() && this.canUseMaterial(material2)) {
                items.add((Object)this.withMaterial(MaterialRegistry.getMaterial(materialId)));
                added = true;
            }
            if (!added) {
                for (IMaterial material2 : MaterialRegistry.getInstance().getVisibleMaterials()) {
                    if (!this.canUseMaterial(material2)) continue;
                    items.add((Object)this.withMaterial(material2));
                    if (showOnlyId.isEmpty()) continue;
                    break;
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IMaterial material = this.getMaterial(stack);
        if (material == IMaterial.UNKNOWN) {
            return super.func_200295_i(stack);
        }
        String key = this.func_77667_c(stack);
        MaterialId loc = material.getIdentifier();
        String fullKey = String.format("%s.%s.%s", key, loc.func_110624_b(), loc.func_110623_a());
        if (Util.canTranslate(fullKey)) {
            return new TranslationTextComponent(fullKey);
        }
        String materialKey = material.getTranslationKey();
        String materialPrefix = materialKey + ".format";
        if (Util.canTranslate(materialPrefix)) {
            return new TranslationTextComponent(materialPrefix, new Object[]{new TranslationTextComponent(key)});
        }
        return new TranslationTextComponent(materialKey).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(key));
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        ResourceLocation id = this.getMaterialId(stack).map(loc -> loc).orElse(this.getRegistryName());
        return id == null ? null : id.func_110624_b();
    }

    protected static void addModTooltip(IMaterial material, List<ITextComponent> tooltip) {
        if (material != IMaterial.UNKNOWN) {
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add((ITextComponent)new TranslationTextComponent(ADDED_BY, new Object[]{DomainDisplayName.nameFor(material.getIdentifier().func_110624_b())}));
        }
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("tag", 10)) {
            CompoundNBT tag = nbt.func_74775_l("tag");
            MaterialItem.getMaterialId(tag).map(id -> {
                MaterialId resolved = MaterialRegistry.getInstance().resolve((MaterialId)((Object)id));
                return resolved == id ? null : resolved;
            }).ifPresent(id -> tag.func_74778_a("Material", id.toString()));
        }
        return true;
    }
}

