/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.controller;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.network.StructureErrorPositionPacket;
import slimeknights.tconstruct.smeltery.tileentity.controller.HeatingStructureTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockResult;

public abstract class HeatingControllerBlock
extends ControllerBlock {
    protected HeatingControllerBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    @Override
    protected boolean openGui(PlayerEntity player, World world, BlockPos pos) {
        super.openGui(player, world, pos);
        if (!world.field_72995_K) {
            TileEntityHelper.getTile(HeatingStructureTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> {
                MultiblockResult result = te.getStructureResult();
                if (!result.isSuccess() && te.showDebugBlockBorder(player)) {
                    TinkerNetwork.getInstance().sendTo(new StructureErrorPositionPacket(pos, result.getPos()), player);
                }
            });
        }
        return true;
    }

    @Override
    protected boolean displayStatus(PlayerEntity player, World world, BlockPos pos, BlockState state) {
        if (!world.field_72995_K) {
            TileEntityHelper.getTile(HeatingStructureTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> {
                MultiblockResult result = te.getStructureResult();
                if (!result.isSuccess()) {
                    player.func_146105_b(result.getMessage(), true);
                    TinkerNetwork.getInstance().sendTo(new StructureErrorPositionPacket(pos, result.getPos()), player);
                }
            });
        }
        return true;
    }
}

