/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.tables.block.TinkerTableBlock;
import slimeknights.tconstruct.tables.tileentity.chest.ChestTileEntity;
import slimeknights.tconstruct.tables.tileentity.chest.IChestItemHandler;

public class ChestBlock
extends TinkerTableBlock {
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)2.5, (double)15.0, (double)2.5), Block.func_208617_a((double)13.5, (double)0.0, (double)0.5, (double)15.5, (double)15.0, (double)2.5), Block.func_208617_a((double)13.5, (double)0.0, (double)13.5, (double)15.5, (double)15.0, (double)15.5), Block.func_208617_a((double)0.5, (double)0.0, (double)13.5, (double)2.5, (double)15.0, (double)15.5)});
    private final Supplier<? extends TileEntity> te;
    private final boolean dropsItems;

    public ChestBlock(AbstractBlock.Properties builder, Supplier<? extends TileEntity> te, boolean dropsItems) {
        super(builder);
        this.te = te;
        this.dropsItems = dropsItems;
    }

    @Nonnull
    public TileEntity createTileEntity(BlockState blockState, IBlockReader iBlockReader) {
        return this.te.get();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("TinkerData", 10)) {
            CompoundNBT tinkerData = tag.func_74775_l("TinkerData");
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof ChestTileEntity) {
                ((ChestTileEntity)te).readInventory(tinkerData);
            }
        }
    }

    @Override
    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        IChestItemHandler itemHandler;
        ItemStack rest;
        ChestTileEntity chest;
        TileEntity te = worldIn.func_175625_s(pos);
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (!heldItem.func_190926_b() && te instanceof ChestTileEntity && (chest = (ChestTileEntity)te).canInsert(player, heldItem) && ((rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = chest.getItemHandler()), (ItemStack)heldItem, (boolean)false)).func_190926_b() || rest.func_190916_E() < heldItem.func_190916_E())) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)rest);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected void dropInventoryItems(BlockState state, World worldIn, BlockPos pos, IItemHandler inventory) {
        if (this.dropsItems) {
            ChestBlock.dropInventoryItems((World)worldIn, (BlockPos)pos, (IItemHandler)inventory);
        }
    }
}

