/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.modifiers.impl.InventoryModifier;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ToolBeltModifier
extends InventoryModifier
implements IArmorInteractModifier {
    private static final ResourceLocation KEY = TConstruct.getResource("tool_belt");
    private static final Pattern PATTERN = new Pattern("tconstruct", "tool_belt");

    public ToolBeltModifier() {
        super(8993573, KEY, 4);
    }

    @Override
    public int getPriority() {
        return 85;
    }

    @Override
    public int getSlots(IToolContext tool, int level) {
        return Math.min(9, level * 4 + tool.getModifierLevel((Modifier)TinkerModifiers.pocketChain.get()));
    }

    @Override
    public boolean startArmorInteract(IModifierToolStack tool, int level, PlayerEntity player, EquipmentSlotType equipmentSlot) {
        if (!player.func_225608_bj_()) {
            ListNBT original;
            if (player.field_70170_p.field_72995_K) {
                return false;
            }
            boolean didChange = false;
            int slots = this.getSlots(tool, level);
            ModDataNBT persistentData = tool.getPersistentData();
            ListNBT list = new ListNBT();
            boolean[] swapped = new boolean[slots];
            if (persistentData.contains(KEY, 9) && !(original = (ListNBT)persistentData.get(KEY, GET_COMPOUND_LIST)).isEmpty()) {
                for (int i = 0; i < original.size(); ++i) {
                    CompoundNBT compoundNBT = original.func_150305_b(i);
                    int slot = compoundNBT.func_74762_e("Slot");
                    if (slot >= slots) continue;
                    ItemStack hotbar = player.field_71071_by.func_70301_a(slot);
                    if (hotbar.func_190926_b() || !ToolInventoryCapability.isBlacklisted(hotbar)) {
                        ItemStack parsed = ItemStack.func_199557_a((CompoundNBT)compoundNBT);
                        player.field_71071_by.func_70299_a(slot, parsed);
                        if (!hotbar.func_190926_b()) {
                            list.add((Object)ToolBeltModifier.write(hotbar, slot));
                        }
                        didChange = true;
                    }
                    swapped[slot] = true;
                }
            }
            for (int i = 0; i < slots; ++i) {
                ItemStack hotbar;
                if (swapped[i] || (hotbar = player.field_71071_by.func_70301_a(i)).func_190926_b() || ToolInventoryCapability.isBlacklisted(hotbar)) continue;
                list.add((Object)ToolBeltModifier.write(hotbar, i));
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                didChange = true;
            }
            if (didChange) {
                persistentData.put(KEY, (INBT)list);
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Pattern getPattern(IModifierToolStack tool, int level, int slot, boolean hasStack) {
        return PATTERN;
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IArmorInteractModifier.class) {
            return (T)this;
        }
        return super.getModule(type);
    }
}

