/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.tools.logic.ModifierMaxLevel;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class MagicProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> MAGIC_DATA = TConstruct.createKey("magic_protection");

    public MagicProtectionModifier() {
        super(16044898, MAGIC_DATA);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PotionEvent.PotionAddedEvent.class, MagicProtectionModifier::onPotionStart);
    }

    @Override
    public float getProtectionModifier(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float modifierValue) {
        if (!source.func_151517_h() && !source.func_76357_e() && source.func_82725_o()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.0f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.0f, tooltip);
    }

    @Override
    protected ModifierMaxLevel createData() {
        return new ModifierMaxLevel();
    }

    private static void onPotionStart(PotionEvent.PotionAddedEvent event) {
        EffectInstance newEffect = event.getPotionEffect();
        if (!newEffect.func_188419_a().func_188408_i() && !newEffect.getCurativeItems().isEmpty()) {
            LivingEntity living = event.getEntityLiving();
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                float max;
                ModifierMaxLevel magicData = data.get(MAGIC_DATA);
                if (magicData != null && (max = magicData.getMax()) > 0.0f) {
                    int duration = (int)((float)newEffect.func_76459_b() * (1.0f - max * 0.05f));
                    if (duration < 0) {
                        duration = 0;
                    }
                    newEffect.field_76460_b = duration;
                }
            });
        }
    }
}

