/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.shared.TinkerCommons;

public class TastyModifier
extends Modifier {
    private static final ResourceLocation IS_EATING = TConstruct.getResource("eating_tasty");

    public TastyModifier() {
        super(15771812);
    }

    @Override
    public ActionResultType onToolUse(IModifierToolStack tool, int level, World world, PlayerEntity player, Hand hand) {
        if (!tool.isBroken() && player.func_71043_e(false)) {
            player.func_184598_c(hand);
            tool.getPersistentData().putBoolean(IS_EATING, true);
            return ActionResultType.CONSUME;
        }
        tool.getPersistentData().remove(IS_EATING);
        return ActionResultType.PASS;
    }

    @Override
    public boolean onStoppedUsing(IModifierToolStack tool, int level, World world, LivingEntity entity, int timeLeft) {
        tool.getPersistentData().remove(IS_EATING);
        return false;
    }

    @Override
    public boolean onFinishUsing(IModifierToolStack tool, int level, World world, LivingEntity entity) {
        PlayerEntity player;
        ModDataNBT persistentData = tool.getPersistentData();
        boolean wasEating = persistentData.getBoolean(IS_EATING);
        persistentData.remove(IS_EATING);
        if (!tool.isBroken() && wasEating && entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_71043_e(false)) {
            player.func_71024_bL().func_75122_a(level, (float)level * 0.1f);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)tool.getItem()));
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187537_bA, SoundCategory.NEUTRAL, 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.NEUTRAL, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (ToolDamageUtil.directDamage(tool, 15 * level, (LivingEntity)player, player.func_184607_cu())) {
                player.func_213334_d(player.func_184600_cs());
            }
            return true;
        }
        return false;
    }

    @Override
    public UseAction getUseAction(IModifierToolStack tool, int level) {
        return tool.getPersistentData().getBoolean(IS_EATING) ? UseAction.EAT : UseAction.NONE;
    }

    @Override
    public int getUseDuration(IModifierToolStack tool, int level) {
        return tool.getPersistentData().getBoolean(IS_EATING) ? 16 : 0;
    }

    @Override
    public List<ItemStack> processLoot(IModifierToolStack tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        if (!context.func_216033_a(LootParameters.field_216283_c)) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity != null && TinkerTags.EntityTypes.BACON_PRODUCER.func_230235_a_((Object)entity.func_200600_R())) {
            int looting = context.getLootingModifier();
            if (RANDOM.nextInt(48 / level) <= looting) {
                generatedLoot.add(new ItemStack(TinkerCommons.bacon));
            }
        }
        return generatedLoot;
    }
}

