/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DwarvenModifier
extends Modifier {
    private static final ITextComponent MINING_SPEED = TConstruct.makeTranslation("modifier", "dwarven.mining_speed");
    private static final int SEA_LEVEL = 64;
    private static final float BOOST_AT_0 = 0.1f;

    public DwarvenModifier() {
        super(16352840);
    }

    private static float getBoost(int y, int level) {
        return (float)((64 - y) * level) * 0.0015625f;
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        float factor = DwarvenModifier.getBoost(event.getPos().func_177956_o(), level);
        if (factor > 0.0f) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + factor));
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        double boost;
        if (tool.hasTag((ITag<Item>)TinkerTags.Items.HARVEST) && (boost = player != null && key == TooltipKey.SHIFT ? (double)DwarvenModifier.getBoost((int)player.func_226278_cu_(), level) : (double)(0.1f * (float)level)) > 0.0) {
            this.addPercentTooltip(MINING_SPEED, boost, tooltip);
        }
    }
}

