/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.init;

import com.mojang.brigadier.CommandDispatcher;
import com.yungnickyoung.minecraft.travelerstitles.command.BiomeTitleCommand;
import com.yungnickyoung.minecraft.travelerstitles.command.DimensionTitleCommand;
import com.yungnickyoung.minecraft.travelerstitles.config.TTConfig;
import com.yungnickyoung.minecraft.travelerstitles.render.TitleRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;

public class TTModClient {
    public static TitleRenderer<Biome> biomeTitleRenderer = new TitleRenderer((Integer)TTConfig.biomes.recentBiomeCacheSize.get(), (Boolean)TTConfig.biomes.enabled.get(), (Integer)TTConfig.biomes.textFadeInTime.get(), (Integer)TTConfig.biomes.textDisplayTime.get(), (Integer)TTConfig.biomes.textFadeOutTime.get(), (String)TTConfig.biomes.textColor.get(), (Boolean)TTConfig.biomes.renderShadow.get(), (Double)TTConfig.biomes.textSize.get(), (Double)TTConfig.biomes.textXOffset.get(), (Double)TTConfig.biomes.textYOffset.get(), (Boolean)TTConfig.biomes.centerText.get());
    public static TitleRenderer<DimensionType> dimensionTitleRenderer = new TitleRenderer(1, (Boolean)TTConfig.dimensions.enabled.get(), (Integer)TTConfig.dimensions.textFadeInTime.get(), (Integer)TTConfig.dimensions.textDisplayTime.get(), (Integer)TTConfig.dimensions.textFadeOutTime.get(), (String)TTConfig.dimensions.textColor.get(), (Boolean)TTConfig.dimensions.renderShadow.get(), (Double)TTConfig.dimensions.textSize.get(), (Double)TTConfig.dimensions.textXOffset.get(), (Double)TTConfig.dimensions.textYOffset.get(), (Boolean)TTConfig.dimensions.centerText.get());
    public static List<String> blacklistedBiomes = new ArrayList<String>();
    public static List<String> blacklistedDimensions = new ArrayList<String>();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(TTModClient::showTextOnBiomeOrDimensionChange);
        MinecraftForge.EVENT_BUS.addListener(TTModClient::clientTick);
        MinecraftForge.EVENT_BUS.addListener(TTModClient::renderTitles);
        MinecraftForge.EVENT_BUS.addListener(TTModClient::registerCommands);
    }

    public static void showTextOnBiomeOrDimensionChange(TickEvent.PlayerTickEvent event) {
        BlockPos currPos;
        if (event.player instanceof ClientPlayerEntity && event.player.field_70170_p != null && event.player.field_70170_p.func_195588_v(currPos = event.player.func_233580_cy_())) {
            if (((Boolean)TTConfig.general.onlyUpdateAtSurface.get()).booleanValue() && event.player.field_70170_p.func_230315_m_().func_218272_d() && !event.player.field_70170_p.func_175710_j(currPos)) {
                return;
            }
            DimensionType currDimension = event.player.field_70170_p.func_230315_m_();
            if (TTModClient.dimensionTitleRenderer.enabled && !dimensionTitleRenderer.containsEntry(d -> d == currDimension)) {
                if (((Boolean)TTConfig.biomes.resetBiomeCacheOnDimensionChange.get()).booleanValue()) {
                    biomeTitleRenderer.reset();
                    TTModClient.biomeTitleRenderer.recentEntries.clear();
                }
                ResourceLocation dimensionBaseKey = event.player.field_70170_p.func_234923_W_().func_240901_a_();
                String dimensionNameKey = Util.func_200697_a((String)"travelerstitles", (ResourceLocation)dimensionBaseKey);
                if (!blacklistedDimensions.contains(dimensionBaseKey.toString())) {
                    TranslationTextComponent dimensionTitle = LanguageMap.func_74808_a().func_230506_b_(dimensionNameKey) ? new TranslationTextComponent(dimensionNameKey) : new StringTextComponent("???");
                    String dimensionColorKey = dimensionNameKey + ".color";
                    String dimensionColorStr = LanguageMap.func_74808_a().func_230506_b_(dimensionColorKey) ? LanguageMap.func_74808_a().func_230503_a_(dimensionColorKey) : TTModClient.dimensionTitleRenderer.titleDefaultTextColor;
                    dimensionTitleRenderer.setColor(dimensionColorStr);
                    dimensionTitleRenderer.displayTitle((ITextComponent)dimensionTitle, null);
                    dimensionTitleRenderer.addRecentEntry(currDimension);
                }
            }
            Biome currBiome = event.player.field_70170_p.func_226691_t_(currPos);
            ResourceLocation biomeBaseKey = event.player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)currBiome);
            String overrideBiomeNameKey = Util.func_200697_a((String)"travelerstitles.biome", (ResourceLocation)biomeBaseKey);
            String normalBiomeNameKey = Util.func_200697_a((String)"biome", (ResourceLocation)biomeBaseKey);
            if (TTModClient.biomeTitleRenderer.enabled && TTModClient.biomeTitleRenderer.cooldownTimer <= 0 && !biomeTitleRenderer.containsEntry(b -> event.player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c(b) == biomeBaseKey) && biomeBaseKey != null && !blacklistedBiomes.contains(biomeBaseKey.toString())) {
                TranslationTextComponent biomeTitle;
                if (LanguageMap.func_74808_a().func_230506_b_(overrideBiomeNameKey)) {
                    biomeTitle = new TranslationTextComponent(overrideBiomeNameKey);
                } else if (LanguageMap.func_74808_a().func_230506_b_(normalBiomeNameKey)) {
                    biomeTitle = new TranslationTextComponent(normalBiomeNameKey);
                } else {
                    return;
                }
                String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
                String normalBiomeColorKey = normalBiomeNameKey + ".color";
                String biomeColorStr = LanguageMap.func_74808_a().func_230506_b_(overrideBiomeColorKey) ? LanguageMap.func_74808_a().func_230503_a_(overrideBiomeColorKey) : (LanguageMap.func_74808_a().func_230506_b_(normalBiomeColorKey) ? LanguageMap.func_74808_a().func_230503_a_(normalBiomeColorKey) : TTModClient.biomeTitleRenderer.titleDefaultTextColor);
                if (TTModClient.biomeTitleRenderer.displayedTitle != null && biomeTitle.getString().equals(TTModClient.biomeTitleRenderer.displayedTitle.getString())) {
                    return;
                }
                biomeTitleRenderer.setColor(biomeColorStr);
                biomeTitleRenderer.displayTitle((ITextComponent)biomeTitle, null);
                TTModClient.biomeTitleRenderer.cooldownTimer = (Integer)TTConfig.biomes.textCooldownTime.get();
                biomeTitleRenderer.addRecentEntry(currBiome);
            }
        }
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().func_147113_T()) {
            biomeTitleRenderer.tick();
            dimensionTitleRenderer.tick();
        }
    }

    public static void renderTitles(RenderGameOverlayEvent.Pre event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            biomeTitleRenderer.renderText(event);
            dimensionTitleRenderer.renderText(event);
        }
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        BiomeTitleCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        DimensionTitleCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }
}

