/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.criteria;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yungnickyoung.minecraft.yungsapi.criteria.SafeStructureLocatePredicate;
import com.yungnickyoung.minecraft.yungsapi.init.YAModCriteria;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;

@MethodsReturnNonnullByDefault
public class SafeStructurePositionTrigger
extends AbstractCriterionTrigger<Instance> {
    private final ResourceLocation id;

    public SafeStructurePositionTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof ServerPlayerEntity && event.player.field_70173_aa % 20 == 0) {
            YAModCriteria.SAFE_STRUCTURE_POSITION_TRIGGER.trigger((ServerPlayerEntity)event.player);
        }
    }

    @ParametersAreNonnullByDefault
    public Instance deserializeTrigger(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        JsonObject jsonobject = JSONUtils.func_151218_a((JsonObject)json, (String)"location", (JsonObject)json);
        SafeStructureLocatePredicate safeStructureLocatePredicate = SafeStructureLocatePredicate.deserialize((JsonElement)jsonobject);
        return new Instance(this.id, entityPredicate, safeStructureLocatePredicate);
    }

    public void trigger(ServerPlayerEntity player) {
        this.func_235959_a_(player, instance -> instance.test(player.func_71121_q(), player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()));
    }

    public static class Instance
    extends CriterionInstance {
        private final SafeStructureLocatePredicate location;

        public Instance(ResourceLocation id, EntityPredicate.AndPredicate player, SafeStructureLocatePredicate location) {
            super(id, player);
            this.location = location;
        }

        public static Instance forLocation(SafeStructureLocatePredicate location) {
            return new Instance(CriteriaTriggers.field_192135_o.func_192163_a(), EntityPredicate.AndPredicate.field_234582_a_, location);
        }

        public boolean test(ServerWorld world, double x, double y, double z) {
            return this.location.test(world, x, y, z);
        }

        @ParametersAreNonnullByDefault
        public JsonObject func_230240_a_(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.func_230240_a_(conditions);
            jsonobject.add("location", this.location.serialize());
            return jsonobject;
        }
    }
}

