/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.world.modification;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public final class BiomeModificationPredicates {
    public static final BiPredicate<RegistryKey<Biome>, Biome> END_ONLY = BiomeModificationPredicates.forCategory(Biome.Category.THEEND);
    public static final BiPredicate<RegistryKey<Biome>, Biome> NETHER_ONLY = BiomeModificationPredicates.forCategory(Biome.Category.NETHER);
    public static final BiPredicate<RegistryKey<Biome>, Biome> OCEAN_ONLY = BiomeModificationPredicates.forCategory(Biome.Category.OCEAN);

    public static BiPredicate<RegistryKey<Biome>, Biome> forBiomeKey(RegistryKey<Biome> biomeKey) {
        return (biomeRegistryKey, biome) -> biomeRegistryKey == biomeKey;
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forBiomeKeys(Set<RegistryKey<Biome>> biomeKeys) {
        return (biomeRegistryKey, biome) -> biomeKeys.contains(biomeRegistryKey);
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forBiome(Biome biomeIn) {
        return (biomeRegistryKey, biome) -> biomeIn == biome;
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forBiome(Supplier<Biome> biomeIn) {
        return (biomeRegistryKey, biome) -> biomeIn.get() == biome;
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forCategory(Biome.Category category) {
        return (biomeRegistryKey, biome) -> biome.func_201856_r() == category;
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forCategory(Biome.Category ... categories) {
        return (biomeRegistryKey, biome) -> Sets.newHashSet((Object[])categories).contains(biome.func_201856_r());
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forType(BiomeDictionary.Type type) {
        return (biomeRegistryKey, biome) -> BiomeDictionary.hasType((RegistryKey)biomeRegistryKey, (BiomeDictionary.Type)type);
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forTypes(BiomeDictionary.Type ... types) {
        return (biomeRegistryKey, biome) -> {
            Set dictTypes = BiomeDictionary.getTypes((RegistryKey)biomeRegistryKey);
            for (BiomeDictionary.Type type : types) {
                if (dictTypes.contains(type)) continue;
                return false;
            }
            return true;
        };
    }

    public static BiPredicate<RegistryKey<Biome>, Biome> forAnyType(BiomeDictionary.Type ... types) {
        return (biomeRegistryKey, biome) -> {
            Set dictTypes = BiomeDictionary.getTypes((RegistryKey)biomeRegistryKey);
            for (BiomeDictionary.Type type : types) {
                if (!dictTypes.contains(type)) continue;
                return true;
            }
            return false;
        };
    }
}

