/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.modification;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.minecraftabnormals.abnormals_core.core.util.modification.ModifierRegistry;
import com.minecraftabnormals.abnormals_core.core.util.modification.TargetedModifier;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModifierDataProvider<T, S, D>
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator dataGenerator;
    private final String name;
    private final Gson gson;
    private final BiFunction<Path, ProviderEntry<T, S, D>, Path> pathResolver;
    private final String targetKeyName;
    private final ModifierRegistry<T, S, D> modifierRegistry;
    private final Function<TargetedModifier<T, S, D>, S> additionalSerializationGetter;
    private final List<ProviderEntry<T, S, D>> entries;

    @SafeVarargs
    public ModifierDataProvider(DataGenerator dataGenerator, String name, Gson gson, BiFunction<Path, ProviderEntry<T, S, D>, Path> pathResolver, String targetKeyName, ModifierRegistry<T, S, D> modifierRegistry, Function<TargetedModifier<T, S, D>, S> additionalSerializationGetter, ProviderEntry<T, S, D> ... toGenerate) {
        this.dataGenerator = dataGenerator;
        this.name = name;
        this.gson = gson;
        this.pathResolver = pathResolver;
        this.targetKeyName = targetKeyName;
        this.modifierRegistry = modifierRegistry;
        this.additionalSerializationGetter = additionalSerializationGetter;
        this.entries = Arrays.asList(toGenerate);
    }

    @SafeVarargs
    public ModifierDataProvider(DataGenerator dataGenerator, String name, Gson gson, String modId, String pathType, ModifierRegistry<T, S, D> modifierRegistry, S serializerObject, ProviderEntry<T, S, D> ... toGenerate) {
        this(dataGenerator, name, gson, (Path path, ProviderEntry<T, S, D> tsdProviderEntry) -> path.resolve("data/" + modId + "/" + pathType + "/" + tsdProviderEntry.name.func_110623_a() + ".json"), "target", modifierRegistry, tsdTargetedModifier -> serializerObject, toGenerate);
    }

    public void func_200398_a(DirectoryCache directoryCache) {
        Path outputFolder = this.dataGenerator.func_200391_b();
        HashSet entryNames = Sets.newHashSet();
        BiFunction<Path, ProviderEntry<T, S, D>, Path> pathResolver = this.pathResolver;
        Gson gson = this.gson;
        Function<TargetedModifier<T, S, D>, S> additionalSerializationGetter = this.additionalSerializationGetter;
        ModifierRegistry<T, S, D> modifierRegistry = this.modifierRegistry;
        this.entries.forEach(entry -> {
            if (!entryNames.add(entry.name)) {
                throw new IllegalStateException("Duplicate modifier: " + entry.name);
            }
            Path resolvedPath = (Path)pathResolver.apply(outputFolder, (ProviderEntry<T, S, D>)entry);
            try {
                TargetedModifier targetedModifier = entry.targetedModifier;
                IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)directoryCache, (JsonElement)targetedModifier.serialize(additionalSerializationGetter.apply(targetedModifier), this.targetKeyName, modifierRegistry, entry.conditions), (Path)resolvedPath);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save modifier {}", (Object)resolvedPath, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return this.name;
    }

    public static class ProviderEntry<T, S, D> {
        private static final ICondition[][] NO_CONDITIONS = new ICondition[0][];
        public final TargetedModifier<T, S, D> targetedModifier;
        public final ICondition[][] conditions;
        public final ResourceLocation name;

        public ProviderEntry(TargetedModifier<T, S, D> targetedModifier, ICondition[][] conditions, ResourceLocation name) {
            this.targetedModifier = targetedModifier;
            this.conditions = conditions;
            this.name = name;
        }

        public ProviderEntry(TargetedModifier<T, S, D> targetedModifier, ICondition[][] conditions) {
            this(targetedModifier, conditions, targetedModifier.getTarget());
        }

        public ProviderEntry(TargetedModifier<T, S, D> targetedModifier) {
            this(targetedModifier, NO_CONDITIONS, targetedModifier.getTarget());
        }
    }
}

