/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntityVoidPortal;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderVoidPortal
extends EntityRenderer<EntityVoidPortal> {
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("alexsmobs:textures/entity/portal/portal_idle_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("alexsmobs:textures/entity/portal/portal_idle_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("alexsmobs:textures/entity/portal/portal_idle_2.png");
    private static final ResourceLocation[] TEXTURE_PROGRESS = new ResourceLocation[10];

    public RenderVoidPortal(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        for (int i = 0; i < 10; ++i) {
            RenderVoidPortal.TEXTURE_PROGRESS[i] = new ResourceLocation("alexsmobs:textures/entity/portal/portal_grow_" + i + ".png");
        }
    }

    public void render(EntityVoidPortal entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(entityIn.getAttachmentFacing().func_176734_d().func_229384_a_());
        matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        ResourceLocation tex = entityIn.getLifespan() < 20 ? this.getGrowingTexture((int)((float)entityIn.getLifespan() * 0.5f % 10.0f)) : (entityIn.field_70173_aa < 20 ? this.getGrowingTexture((int)((float)entityIn.field_70173_aa * 0.5f % 10.0f)) : this.getIdleTexture(entityIn.field_70173_aa % 9));
        matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
        this.renderArc(matrixStackIn, bufferIn, tex);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderArc(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, ResourceLocation res) {
        matrixStackIn.func_227860_a_();
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(AMRenderTypes.getGhost(res));
        MatrixStack.Entry lvt_19_1_ = matrixStackIn.func_227866_c_();
        Matrix4f lvt_20_1_ = lvt_19_1_.func_227870_a_();
        Matrix3f lvt_21_1_ = lvt_19_1_.func_227872_b_();
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, -1, 0, -1, 0.0f, 0.0f, 1, 0, 1, 240);
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, -1, 0, 1, 0.0f, 1.0f, 1, 0, 1, 240);
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, 1, 0, 1, 1.0f, 1.0f, 1, 0, 1, 240);
        this.drawVertex(lvt_20_1_, lvt_21_1_, ivertexbuilder, 1, 0, -1, 1.0f, 0.0f, 1, 0, 1, 240);
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(EntityVoidPortal entity) {
        return TEXTURE_0;
    }

    public void drawVertex(Matrix4f p_229039_1_, Matrix3f p_229039_2_, IVertexBuilder p_229039_3_, int p_229039_4_, int p_229039_5_, int p_229039_6_, float p_229039_7_, float p_229039_8_, int p_229039_9_, int p_229039_10_, int p_229039_11_, int p_229039_12_) {
        p_229039_3_.func_227888_a_(p_229039_1_, (float)p_229039_4_, (float)p_229039_5_, (float)p_229039_6_).func_225586_a_(255, 255, 255, 255).func_225583_a_(p_229039_7_, p_229039_8_).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(p_229039_12_).func_227887_a_(p_229039_2_, (float)p_229039_9_, (float)p_229039_11_, (float)p_229039_10_).func_181675_d();
    }

    public ResourceLocation getIdleTexture(int age) {
        if (age < 3) {
            return TEXTURE_0;
        }
        if (age < 6) {
            return TEXTURE_1;
        }
        if (age < 10) {
            return TEXTURE_2;
        }
        return TEXTURE_0;
    }

    public ResourceLocation getGrowingTexture(int age) {
        return TEXTURE_PROGRESS[MathHelper.func_76125_a((int)age, (int)0, (int)9)];
    }
}

