/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalSwimMoveControllerSink;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.PlatypusAIDigForItems;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityPlatypus
extends AnimalEntity
implements ISemiAquatic,
ITargetsDroppedItems {
    private static final DataParameter<Boolean> SENSING = EntityDataManager.func_187226_a(EntityPlatypus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SENSING_VISUAL = EntityDataManager.func_187226_a(EntityPlatypus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DIGGING = EntityDataManager.func_187226_a(EntityPlatypus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FEDORA = EntityDataManager.func_187226_a(EntityPlatypus.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevInWaterProgress;
    public float inWaterProgress;
    public float prevDigProgress;
    public float digProgress;
    public boolean superCharged = false;
    private boolean isLandNavigator;
    private int swimTimer = -1000;

    protected EntityPlatypus(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public static boolean canPlatypusSpawn(EntityType type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        ITag tag = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.PLATYPUS_SPAWNS);
        boolean spawnBlock = tag != null && tag.func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return (tag == null && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150346_d || spawnBlock) && pos.func_177956_o() < worldIn.func_181545_F() + 4;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.platypusSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == AMItemRegistry.LOBSTER_TAIL || item == AMItemRegistry.COOKED_LOBSTER_TAIL;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.PLATYPUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.PLATYPUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.PLATYPUS_HURT;
    }

    protected ItemStack getFishBucket() {
        ItemStack stack = new ItemStack((IItemProvider)AMItemRegistry.PLATYPUS_BUCKET);
        CompoundNBT platTag = new CompoundNBT();
        this.func_213281_b(platTag);
        stack.func_196082_o().func_218657_a("PlatypusData", (INBT)platTag);
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        return stack;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        boolean redstone;
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        boolean bl = redstone = itemstack.func_77973_b() == Items.field_151137_ax || itemstack.func_77973_b() == Items.field_221858_em;
        if (itemstack.func_77973_b() == AMItemRegistry.FEDORA && !this.hasFedora()) {
            if (!p_230254_1_.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.setFedora(true);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (redstone && !this.isSensing()) {
            boolean bl2 = this.superCharged = itemstack.func_77973_b() == Items.field_221858_em;
            if (!p_230254_1_.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.setSensing(true);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (itemstack.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)p_230254_1_, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                p_230254_1_.func_184611_a(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.field_71071_by.func_70441_a(itemstack1)) {
                p_230254_1_.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax, Items.field_221858_em}), false){

            public void func_75249_e() {
                super.func_75249_e();
                EntityPlatypus.this.setSensingVisual(true);
            }

            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityPlatypus.this.isSensing();
            }

            public void func_75251_c() {
                super.func_75251_c();
                EntityPlatypus.this.setSensingVisual(false);
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_199910_a(AMTagRegistry.PLATYPUS_FOODSTUFFS)), false){

            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityPlatypus.this.isSensing();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new PlatypusAIDigForItems(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new SemiAquaticAIRandomSwimming(this, 1.0, 30));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 60));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new CreatureAITargetItems((CreatureEntity)this, false, false, 40, 15){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityPlatypus.this.isSensing();
            }

            @Override
            public boolean func_75253_b() {
                return super.func_75253_b() && !EntityPlatypus.this.isSensing();
            }
        });
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev && source.func_76364_f() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)source.func_76364_f();
            entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
        }
        return prev;
    }

    public boolean isPerry() {
        String s = TextFormatting.func_110646_a((String)this.func_200200_C_().getString());
        return s != null && s.toLowerCase().contains("perry");
    }

    public int func_205010_bg() {
        return 4800;
    }

    protected int func_207300_l(int currentAir) {
        return this.func_205010_bg();
    }

    public void spawnGroundEffects() {
        float radius = 0.3f;
        for (int i1 = 0; i1 < 3; ++i1) {
            double motionX = this.func_70681_au().nextGaussian() * 0.07;
            double motionY = this.func_70681_au().nextGaussian() * 0.07;
            double motionZ = this.func_70681_au().nextGaussian() * 0.07;
            float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraY = 0.8f;
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos ground = this.func_226270_aj_();
            BlockState BlockState2 = this.field_70170_p.func_180495_p(ground);
            if (BlockState2.func_185904_a() == Material.field_151579_a || BlockState2.func_185904_a() == Material.field_151586_h || !this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_195590_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, BlockState2), true, this.func_226277_ct_() + extraX, (double)ground.func_177956_o() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_70050_g(this.func_205010_bg());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(SENSING, (Object)false);
        this.field_70180_af.func_187214_a(SENSING_VISUAL, (Object)false);
        this.field_70180_af.func_187214_a(FEDORA, (Object)false);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.hasFedora()) {
            this.func_199703_a((IItemProvider)AMItemRegistry.FEDORA);
        }
    }

    public boolean isSensing() {
        return (Boolean)this.field_70180_af.func_187225_a(SENSING);
    }

    public void setSensing(boolean sensing) {
        this.field_70180_af.func_187227_b(SENSING, (Object)sensing);
    }

    public boolean isSensingVisual() {
        return (Boolean)this.field_70180_af.func_187225_a(SENSING_VISUAL);
    }

    public void setSensingVisual(boolean sensing) {
        this.field_70180_af.func_187227_b(SENSING_VISUAL, (Object)sensing);
    }

    public boolean hasFedora() {
        return (Boolean)this.field_70180_af.func_187225_a(FEDORA);
    }

    public void setFedora(boolean sensing) {
        this.field_70180_af.func_187227_b(FEDORA, (Object)sensing);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Fedora", this.hasFedora());
        compound.func_74757_a("Sensing", this.isSensing());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFedora(compound.func_74767_n("Fedora"));
        this.setSensing(compound.func_74767_n("Sensing"));
    }

    public void func_70071_h_() {
        boolean dig;
        super.func_70071_h_();
        this.prevInWaterProgress = this.inWaterProgress;
        this.prevDigProgress = this.digProgress;
        boolean bl = dig = this.isDigging() && this.func_203005_aq();
        if (dig && this.digProgress < 5.0f) {
            this.digProgress += 1.0f;
        }
        if (!dig && this.digProgress > 0.0f) {
            this.digProgress -= 1.0f;
        }
        if (this.func_203005_aq() && this.inWaterProgress < 5.0f) {
            this.inWaterProgress += 1.0f;
        }
        if (!this.func_203005_aq() && this.inWaterProgress > 0.0f) {
            this.inWaterProgress -= 1.0f;
        }
        if (this.func_203005_aq() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.func_203005_aq() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.field_70122_E && this.isDigging()) {
            this.spawnGroundEffects();
        }
        this.field_70138_W = this.inWaterProgress > 0.0f ? 1.0f : 0.6f;
        if (!this.field_70170_p.field_72995_K) {
            this.swimTimer = this.func_70090_H() ? ++this.swimTimer : --this.swimTimer;
        }
        if (this.func_70089_S() && (this.isSensing() || this.isSensingVisual())) {
            for (int j = 0; j < 2; ++j) {
                float radius = this.func_213311_cf() * 0.65f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX = (double)(radius * (1.5f + this.field_70146_Z.nextFloat() * 0.3f) * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72450_a * 2.0;
                double extraZ = (double)(radius * (1.5f + this.field_70146_Z.nextFloat() * 0.3f) * MathHelper.func_76134_b((float)angle) + (this.field_70146_Z.nextFloat() - 0.5f)) + this.func_213322_ci().field_72449_c * 2.0;
                double actualX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double actualZ = radius * MathHelper.func_76134_b((float)angle);
                double motX = actualX - extraX;
                double motZ = actualZ - extraZ;
                this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.PLATYPUS_SENSE, this.func_226277_ct_() + extraX, (double)(this.func_213302_cg() * 0.3f) + this.func_226278_cu_(), this.func_226281_cx_() + extraZ, motX * (double)0.1f, 0.0, motZ * (double)0.1f);
            }
        }
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.field_70180_af.func_187227_b(DIGGING, (Object)digging);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new AnimalSwimMoveControllerSink((CreatureEntity)this, 1.2f, 1.6f);
            this.field_70699_by = new SemiAquaticPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    @Override
    public boolean shouldEnterWater() {
        return this.func_70643_av() != null || this.swimTimer <= -1000 || this.isSensing();
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.swimTimer > 600 && !this.isSensing();
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isDigging();
    }

    @Override
    public int getWaterSearchRange() {
        return 10;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.PLATYPUS.func_200721_a((World)serverWorld);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return !this.isSensing() && ItemTags.func_199903_a().func_199910_a(AMTagRegistry.PLATYPUS_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.func_184185_a(SoundEvents.field_219607_aG, this.func_70599_aP(), this.func_70647_i());
        if (e.func_92059_d().func_77973_b() == Items.field_151137_ax || e.func_92059_d().func_77973_b() == Items.field_221858_em) {
            this.superCharged = e.func_92059_d().func_77973_b().getItem() == Items.field_221858_em;
            this.setSensing(true);
        } else {
            this.func_70691_i(6.0f);
        }
    }
}

