/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.EntityRaccoon;
import com.github.alexthe666.alexsmobs.entity.ai.ILootsChests;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class AnimalAILootChests
extends MoveToBlockGoal {
    private final AnimalEntity entity;
    private final ILootsChests chestLooter;
    private boolean hasOpenedChest = false;

    public AnimalAILootChests(AnimalEntity entity, int range) {
        super((CreatureEntity)entity, 1.0, range);
        this.entity = entity;
        this.chestLooter = (ILootsChests)entity;
    }

    public boolean isChestRaidable(IWorldReader world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof ContainerBlock) {
            Block block = world.func_180495_p(pos).func_177230_c();
            boolean listed = false;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof IInventory) {
                IInventory inventory = (IInventory)entity;
                try {
                    if (!inventory.func_191420_l() && this.chestLooter.isLootable(inventory)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    AlexsMobs.LOGGER.warn("Alex's Mobs stopped a " + entity.getClass().getSimpleName() + " from causing a crash during access");
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public boolean func_75250_a() {
        if (this.entity instanceof TameableEntity && ((TameableEntity)this.entity).func_70909_n()) {
            return false;
        }
        if (!AMConfig.raccoonsStealFromChests) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        if (this.field_179496_a <= 0 && !ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
            return false;
        }
        return super.func_75250_a();
    }

    public boolean func_75253_b() {
        return super.func_75253_b() && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public boolean canSeeChest() {
        BlockRayTraceResult raytraceresult = this.entity.field_70170_p.func_217299_a(new RayTraceContext(this.entity.func_174824_e(1.0f), new Vector3d((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o() + 0.5, (double)this.field_179494_b.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity));
        if (raytraceresult instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = raytraceresult;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            return pos.equals((Object)this.field_179494_b) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.field_179494_b);
        }
        return true;
    }

    public ItemStack getFoodFromInventory(IInventory inventory, Random random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!this.chestLooter.shouldLootItem(stack)) continue;
            items.add(stack);
        }
        if (items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (items.size() == 1) {
            return (ItemStack)items.get(0);
        }
        return (ItemStack)items.get(random.nextInt(items.size() - 1));
    }

    public void func_75246_d() {
        TileEntity te;
        super.func_75246_d();
        if (this.field_179494_b != null && (te = this.entity.field_70170_p.func_175625_s(this.field_179494_b)) instanceof IInventory) {
            IInventory feeder = (IInventory)te;
            double distance = this.entity.func_70092_e((double)((float)this.field_179494_b.func_177958_n() + 0.5f), (double)((float)this.field_179494_b.func_177956_o() + 0.5f), (double)((float)this.field_179494_b.func_177952_p() + 0.5f));
            if (this.canSeeChest()) {
                if (this.func_179487_f() && distance <= 3.0) {
                    this.toggleChest(feeder, false);
                    ItemStack stack = this.getFoodFromInventory(feeder, this.entity.field_70170_p.field_73012_v);
                    if (stack == ItemStack.field_190927_a) {
                        this.func_75251_c();
                    } else {
                        ItemStack duplicate = stack.func_77946_l();
                        duplicate.func_190920_e(1);
                        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                            this.entity.func_70099_a(this.entity.func_184586_b(Hand.MAIN_HAND), 0.0f);
                        }
                        this.entity.func_184611_a(Hand.MAIN_HAND, duplicate);
                        if (this.entity instanceof EntityRaccoon) {
                            ((EntityRaccoon)this.entity).lookForWaterBeforeEatingTimer = 10;
                        }
                        stack.func_190918_g(1);
                        this.func_75251_c();
                    }
                } else if (distance < 5.0 && !this.hasOpenedChest) {
                    this.hasOpenedChest = true;
                    this.toggleChest(feeder, true);
                }
            }
        }
    }

    public void func_75251_c() {
        TileEntity te;
        super.func_75251_c();
        if (this.field_179494_b != null && (te = this.entity.field_70170_p.func_175625_s(this.field_179494_b)) instanceof IInventory) {
            this.toggleChest((IInventory)te, false);
        }
        this.field_179494_b = null;
        this.hasOpenedChest = false;
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        return pos != null && this.isChestRaidable(worldIn, pos);
    }

    public void toggleChest(IInventory te, boolean open) {
        if (te instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)te;
            if (open) {
                this.entity.field_70170_p.func_175641_c(this.field_179494_b, chest.func_195044_w().func_177230_c(), 1, 1);
            } else {
                this.entity.field_70170_p.func_175641_c(this.field_179494_b, chest.func_195044_w().func_177230_c(), 1, 0);
            }
            chest.field_145987_o = open ? 1 : 0;
            this.entity.field_70170_p.func_195593_d(this.field_179494_b, chest.func_195044_w().func_177230_c());
            this.entity.field_70170_p.func_195593_d(this.field_179494_b.func_177977_b(), chest.func_195044_w().func_177230_c());
        }
    }
}

