/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.tileentity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockLeafcutterAntChamber;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.alexsmobs.tileentity.AMTileEntityRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TileEntityLeafcutterAnthill
extends TileEntity
implements ITickableTileEntity {
    private static final Direction[] DIRECTIONS_UP = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final List<Ant> ants = Lists.newArrayList();
    private int leafFeedings = 0;

    public TileEntityLeafcutterAnthill() {
        super(AMTileEntityRegistry.LEAFCUTTER_ANTHILL);
    }

    public boolean hasNoAnts() {
        return this.ants.isEmpty();
    }

    public boolean isFullOfAnts() {
        return this.ants.size() == AMConfig.leafcutterAntColonySize;
    }

    public void angerAnts(@Nullable LivingEntity p_226963_1_, BlockState p_226963_2_, BeehiveTileEntity.State p_226963_3_) {
        List<Entity> list = this.tryReleaseAnt(p_226963_2_, p_226963_3_);
        if (p_226963_1_ != null) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLeafcutterAnt)) continue;
                EntityLeafcutterAnt entityLeafcutterAnt = (EntityLeafcutterAnt)entity;
                if (p_226963_1_.func_213303_ch().func_72436_e(entity.func_213303_ch()) <= 16.0) {
                    entityLeafcutterAnt.func_70624_b(p_226963_1_);
                }
                entityLeafcutterAnt.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<Entity> tryReleaseAnt(BlockState p_226965_1_, BeehiveTileEntity.State p_226965_2_) {
        ArrayList list = Lists.newArrayList();
        this.ants.removeIf(p_226966_4_ -> this.addAntToWorld(p_226965_1_, (Ant)p_226966_4_, list, p_226965_2_));
        return list;
    }

    private boolean addAntToWorld(BlockState p_235651_1_, Ant p_235651_2_, @Nullable List<Entity> p_235651_3_, BeehiveTileEntity.State p_235651_4_) {
        boolean flag;
        BlockPos blockpos = this.func_174877_v();
        CompoundNBT compoundnbt = p_235651_2_.entityData;
        compoundnbt.func_82580_o("Passengers");
        compoundnbt.func_82580_o("Leash");
        compoundnbt.func_82580_o("UUID");
        BlockPos blockpos1 = blockpos.func_177984_a();
        boolean bl = flag = !this.field_145850_b.func_180495_p(blockpos1).func_196951_e((IBlockReader)this.field_145850_b, blockpos1).func_197766_b();
        if (flag && p_235651_4_ != BeehiveTileEntity.State.EMERGENCY) {
            return false;
        }
        Entity entity = TileEntityLeafcutterAnthill.loadEntityAndExecute(compoundnbt, this.field_145850_b, p_226960_0_ -> p_226960_0_);
        if (entity != null) {
            if (entity instanceof EntityLeafcutterAnt) {
                EntityLeafcutterAnt entityLeafcutterAnt = (EntityLeafcutterAnt)entity;
                entityLeafcutterAnt.setLeaf(false);
                if (p_235651_4_ == BeehiveTileEntity.State.HONEY_DELIVERED) {
                    // empty if block
                }
                if (p_235651_3_ != null) {
                    p_235651_3_.add((Entity)entityLeafcutterAnt);
                }
                float f = entity.func_213311_cf();
                double d0 = (double)blockpos.func_177958_n() + 0.5;
                double d1 = (double)blockpos.func_177956_o() + 1.0;
                double d2 = (double)blockpos.func_177952_p() + 0.5;
                entity.func_70012_b(d0, d1, d2, entity.field_70177_z, entity.field_70125_A);
                if (((EntityLeafcutterAnt)entity).isQueen()) {
                    entityLeafcutterAnt.setStayOutOfHiveCountdown(400);
                }
            }
            this.field_145850_b.func_184133_a(null, blockpos, SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return this.field_145850_b.func_217376_c(entity);
        }
        return false;
    }

    public void tryEnterHive(EntityLeafcutterAnt p_226962_1_, boolean p_226962_2_, int p_226962_3_) {
        if (this.ants.size() < AMConfig.leafcutterAntColonySize) {
            p_226962_1_.func_184210_p();
            p_226962_1_.func_184226_ay();
            CompoundNBT compoundnbt = new CompoundNBT();
            p_226962_1_.func_70039_c(compoundnbt);
            if (p_226962_2_) {
                if (!this.field_145850_b.field_72995_K && (double)p_226962_1_.func_70681_au().nextFloat() < AMConfig.leafcutterAntFungusGrowChance) {
                    this.growFungus();
                }
                ++this.leafFeedings;
                if (this.leafFeedings >= AMConfig.leafcutterAntRepopulateFeedings && this.ants.size() < MathHelper.func_76123_f((float)((float)AMConfig.leafcutterAntColonySize * 0.5f)) && this.hasQueen()) {
                    this.leafFeedings = 0;
                    this.ants.add(new Ant(new CompoundNBT(), 0, 100, false));
                }
            }
            this.ants.add(new Ant(compoundnbt, p_226962_3_, p_226962_2_ ? 100 : 200, p_226962_1_.isQueen()));
            if (this.field_145850_b != null) {
                BlockPos blockpos = this.func_174877_v();
                this.field_145850_b.func_184148_a(null, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            p_226962_1_.func_70106_y();
        }
    }

    public boolean hasQueen() {
        for (Ant ant : this.ants) {
            if (!ant.queen) continue;
            return true;
        }
        return false;
    }

    public void releaseQueens() {
        this.ants.removeIf(p_226966_4_ -> ((Ant)p_226966_4_).queen && this.addAntToWorld(this.func_195044_w(), (Ant)p_226966_4_, null, BeehiveTileEntity.State.BEE_RELEASED));
    }

    public void tryEnterHive(EntityLeafcutterAnt p_226961_1_, boolean p_226961_2_) {
        this.tryEnterHive(p_226961_1_, p_226961_2_, 0);
    }

    public int getAntCount() {
        return this.ants.size();
    }

    public void func_70296_d() {
        if (this.isNearFire()) {
            this.angerAnts(null, this.field_145850_b.func_180495_p(this.func_174877_v()), BeehiveTileEntity.State.EMERGENCY);
        }
        super.func_70296_d();
    }

    public boolean isNearFire() {
        if (this.field_145850_b == null) {
            return false;
        }
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            if (!(this.field_145850_b.func_180495_p(blockpos).func_177230_c() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tickAnts();
        }
    }

    private void growFungus() {
        BlockPos bottomChamber = this.func_174877_v().func_177977_b();
        while (this.field_145850_b.func_180495_p(bottomChamber.func_177977_b()).func_177230_c() == AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER && bottomChamber.func_177956_o() > 0) {
            bottomChamber = bottomChamber.func_177977_b();
        }
        BlockPos chamber = bottomChamber;
        if (this.isUnfilledChamber(chamber)) {
            int fungalLevel = (Integer)this.field_145850_b.func_180495_p(chamber).func_177229_b((Property)BlockLeafcutterAntChamber.FUNGUS);
            int fungalLevel2 = MathHelper.func_76125_a((int)(fungalLevel + 1 + this.field_145850_b.func_201674_k().nextInt(1)), (int)0, (int)5);
            this.field_145850_b.func_175656_a(chamber, (BlockState)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.func_176223_P().func_206870_a((Property)BlockLeafcutterAntChamber.FUNGUS, (Comparable)Integer.valueOf(fungalLevel2)));
        } else {
            BlockPos newChamber;
            boolean flag = false;
            ArrayList<BlockPos> possibleChambers = new ArrayList<BlockPos>();
            while (!flag) {
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)chamber.func_177982_a(-4, 0, -4), (BlockPos)chamber.func_177982_a(4, 0, 4))) {
                    if (!this.isUnfilledChamber(blockpos)) continue;
                    possibleChambers.add(blockpos.func_185334_h());
                    flag = true;
                }
                if (flag || (chamber = chamber.func_177984_a()).func_177956_o() <= this.field_174879_c.func_177956_o()) continue;
                return;
            }
            Collections.shuffle(possibleChambers);
            if (!possibleChambers.isEmpty() && (newChamber = (BlockPos)possibleChambers.get(0)) != null && this.isUnfilledChamber(newChamber)) {
                int fungalLevel = (Integer)this.field_145850_b.func_180495_p(newChamber).func_177229_b((Property)BlockLeafcutterAntChamber.FUNGUS);
                int fungalLevel2 = MathHelper.func_76125_a((int)(fungalLevel + 1 + this.field_145850_b.func_201674_k().nextInt(1)), (int)0, (int)5);
                this.field_145850_b.func_175656_a(newChamber, (BlockState)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.func_176223_P().func_206870_a((Property)BlockLeafcutterAntChamber.FUNGUS, (Comparable)Integer.valueOf(fungalLevel2)));
            }
        }
    }

    private boolean isUnfilledChamber(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER && (Integer)this.field_145850_b.func_180495_p(pos).func_177229_b((Property)BlockLeafcutterAntChamber.FUNGUS) < 5;
    }

    private void tickAnts() {
        Iterator<Ant> iterator = this.ants.iterator();
        BlockState blockstate = this.func_195044_w();
        while (iterator.hasNext()) {
            Ant ant = iterator.next();
            if (ant.ticksInHive > ant.minOccupationTicks && !ant.queen) {
                BeehiveTileEntity.State beehivetileentity$state;
                BeehiveTileEntity.State state = beehivetileentity$state = ant.entityData.func_74767_n("HasNectar") ? BeehiveTileEntity.State.HONEY_DELIVERED : BeehiveTileEntity.State.BEE_RELEASED;
                if (this.addAntToWorld(blockstate, ant, null, beehivetileentity$state)) {
                    iterator.remove();
                }
            }
            ant.ticksInHive++;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.ants.clear();
        this.leafFeedings = nbt.func_74762_e("LeafFeedings");
        ListNBT listnbt = nbt.func_150295_c("Ants", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Ant beehiveTileEntity$ant = new Ant(compoundnbt.func_74775_l("EntityData"), compoundnbt.func_74762_e("TicksInHive"), compoundnbt.func_74762_e("MinOccupationTicks"), compoundnbt.func_74767_n("Queen"));
            this.ants.add(beehiveTileEntity$ant);
        }
    }

    public ListNBT getAnts() {
        ListNBT listnbt = new ListNBT();
        for (Ant beehiveTileEntity$ant : this.ants) {
            beehiveTileEntity$ant.entityData.func_82580_o("UUID");
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_218657_a("EntityData", (INBT)beehiveTileEntity$ant.entityData);
            compoundnbt.func_74768_a("TicksInHive", beehiveTileEntity$ant.ticksInHive);
            compoundnbt.func_74768_a("MinOccupationTicks", beehiveTileEntity$ant.minOccupationTicks);
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Ants", (INBT)this.getAnts());
        compound.func_74768_a("LeafFeedings", this.leafFeedings);
        return compound;
    }

    @Nullable
    public static Entity loadEntityAndExecute(CompoundNBT compound, World worldIn, Function<Entity, Entity> p_220335_2_) {
        return TileEntityLeafcutterAnthill.loadEntity(compound, worldIn).map(p_220335_2_).map(p_220346_3_ -> {
            if (compound.func_150297_b("Passengers", 9)) {
                ListNBT listnbt = compound.func_150295_c("Passengers", 10);
                for (int i = 0; i < listnbt.size(); ++i) {
                    Entity entity = TileEntityLeafcutterAnthill.loadEntityAndExecute(listnbt.func_150305_b(i), worldIn, p_220335_2_);
                    if (entity == null) continue;
                    entity.func_184205_a(p_220346_3_, true);
                }
            }
            return p_220346_3_;
        }).orElse(null);
    }

    private static Optional<Entity> loadEntity(CompoundNBT compound, World worldIn) {
        try {
            return TileEntityLeafcutterAnthill.loadEntityUnchecked(compound, worldIn);
        }
        catch (RuntimeException runtimeexception) {
            return Optional.empty();
        }
    }

    public static Optional<Entity> loadEntityUnchecked(CompoundNBT compound, World worldIn) {
        EntityLeafcutterAnt leafcutterAnt = (EntityLeafcutterAnt)AMEntityRegistry.LEAFCUTTER_ANT.func_200721_a(worldIn);
        leafcutterAnt.func_70020_e(compound);
        return Optional.of(leafcutterAnt);
    }

    static class Ant {
        private final CompoundNBT entityData;
        private final int minOccupationTicks;
        private int ticksInHive;
        private boolean queen;

        private Ant(CompoundNBT p_i225767_1_, int p_i225767_2_, int p_i225767_3_, boolean queen) {
            p_i225767_1_.func_82580_o("UUID");
            this.entityData = p_i225767_1_;
            this.ticksInHive = p_i225767_2_;
            this.minOccupationTicks = p_i225767_3_;
            this.queen = queen;
        }
    }
}

