/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.config.ConfigHelper;
import com.sofodev.armorplus.events.WorldGenEvents;
import com.sofodev.armorplus.network.PacketHandler;
import com.sofodev.armorplus.registry.ModAttributes;
import com.sofodev.armorplus.registry.ModBiomes;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.ModConfiguredFeatures;
import com.sofodev.armorplus.registry.ModEnchantments;
import com.sofodev.armorplus.registry.ModEntities;
import com.sofodev.armorplus.registry.ModFeatures;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.registry.ModPotions;
import com.sofodev.armorplus.registry.ModVillagers;
import com.sofodev.armorplus.registry.blocks.castle.BrickColor;
import com.sofodev.armorplus.registry.blocks.special.TrophyTileEntityRenderer;
import com.sofodev.armorplus.registry.entities.arrows.APArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.APArrowRenderer;
import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonRenderer;
import com.sofodev.armorplus.registry.entities.bosses.SkeletalKingRenderer;
import com.sofodev.armorplus.registry.entities.normal.BoreasRenderer;
import com.sofodev.armorplus.registry.entities.normal.FrostWolfAlphaRenderer;
import com.sofodev.armorplus.registry.entities.normal.FrostWolfRenderer;
import com.sofodev.armorplus.registry.entities.normal.WitherlingRenderer;
import com.sofodev.armorplus.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.registry.items.tools.properties.mace.APMaceMaterial;
import com.sofodev.armorplus.registry.items.tools.properties.tool.APToolProperties;
import com.sofodev.armorplus.utils.GlobalVars;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="armorplus")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="armorplus")
public class ArmorPlus {
    public static final String MODID = "armorplus";
    public static final String MODNAME = "ArmorPlus";
    public static final String VERSION = "1.16.5-16.8.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"armorplus");
    public static final PacketHandler PACKET_HANDLER = new PacketHandler();
    public static final int AP_ARMOR_MATERIAL_LENGTH = APArmorMaterial.values().length;
    public static final int AP_TOOL_MATERIAL_LENGTH = APToolProperties.values().length;
    public static final int AP_STONE_BRICKS_LENGTH = BrickColor.values().length;
    public static final int AP_MACE_MAT_LENGTH = APMaceMaterial.values().length;
    public static final ItemGroup AP_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("armors")){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Utils.getAPItem("infused_lava_chestplate"));
        }
    };
    public static final ItemGroup AP_ITEM_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("items")){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get());
        }
    };
    public static final ItemGroup AP_BLOCK_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("blocks")){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModBlocks.INFUSED_LAVA_CRYSTAL.get());
        }
    };
    public static final ItemGroup AP_WEAPON_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("weapons")){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Utils.getAPItem("ender_dragon_battle_axe"));
        }
    };
    public static ArmorPlusConfig config;
    public static ArmorPlus instance;

    public ArmorPlus() {
        instance = this;
        GeckoLib.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext modLoadingCTX = ModLoadingContext.get();
        config = ConfigHelper.register(ModLoadingContext.get(), FMLJavaModLoadingContext.get(), ModConfig.Type.COMMON, ArmorPlusConfig::new);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        ModBlocks.TILE_ENTITIES.register(modEventBus);
        ModEntities.ENTITY_TYPES.register(modEventBus);
        ModPotions.EFFECTS.register(modEventBus);
        ModFeatures.SURFACE_BUILDERS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModAttributes.ATTRIBUTES.register(modEventBus);
        ModVillagers.PROFESSIONS.register(modEventBus);
        ModVillagers.POI_TYPES.register(modEventBus);
        ModBiomes.BIOMES.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        forgeBus.addListener(EventPriority.HIGH, WorldGenEvents::onBiomeLoad);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::onClientSetup);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerRenderingHandler(EntityType<? extends APArrowEntity> entityClass, String name) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, rm -> new APArrowRenderer(rm, name));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerBowOverrides() {
        Arrays.stream(ModItems.BOWS).forEach(bow -> {
            ItemModelsProperties.func_239418_a_((Item)((Item)bow.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, player) -> {
                if (player == null) {
                    return 0.0f;
                }
                return player.func_184607_cu() != stack ? 0.0f : (float)(stack.func_77988_m() - player.func_184605_cv()) / 20.0f;
            });
            ItemModelsProperties.func_239418_a_((Item)((Item)bow.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, player) -> player != null && player.func_184587_cr() && player.func_184607_cu() == stack ? 1.0f : 0.0f);
        });
    }

    @Nullable
    public static <T> Registry<T> findRegistryByKey(RegistryKey<Registry<T>> key) {
        return (Registry)Registry.field_212617_f.func_230516_a_(key);
    }

    public static ArmorPlus getInstance() {
        return instance;
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::afterSetup);
    }

    private void afterSetup() {
        GlobalVars.registerAfterEverything();
        ModConfiguredFeatures.registerConfiguredFeatures();
        ModConfiguredFeatures.registerConfiguredFeatures();
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)ModBiomes.FROZEN_PLAINS.getId()), 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)ModBiomes.VALLEY_OF_SOULS.getId()), 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)ModBiomes.POSSESSED_GROUNDS.getId()), 5));
        PACKET_HANDLER.initialize();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.COAL_ARROW.get()), "coal");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.LAPIS_ARROW.get()), "lapis");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.REDSTONE_ARROW.get()), "redstone");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.EMERALD_ARROW.get()), "emerald");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.OBSIDIAN_ARROW.get()), "obsidian");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.INFUSED_LAVA_ARROW.get()), "lava");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.GUARDIAN_ARROW.get()), "guardian");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.SUPER_STAR_ARROW.get()), "super_star");
        ArmorPlus.registerRenderingHandler((EntityType<? extends APArrowEntity>)((EntityType)ModEntities.ENDER_DRAGON_ARROW.get()), "ender_dragon");
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.SKELETAL_KING.get()), SkeletalKingRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.WITHERLING.get()), WitherlingRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.DEMONIC_DRAGON.get()), DemonicDragonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.FROST_WOLF.get()), FrostWolfRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.FROST_WOLF_ALPHA.get()), FrostWolfAlphaRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.BOREAS.get()), BoreasRenderer::new);
        this.setRenderLayer(Arrays.asList(ModBlocks.LAVA_INFUSER, ModBlocks.TROPHY));
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModBlocks.TROPHY_TYPE.get()), TrophyTileEntityRenderer::new);
        ArmorPlus.registerBowOverrides();
    }

    private void setRenderLayer(List<RegistryObject<Block>> blocks) {
        blocks.forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
    }

    @Nullable
    public <T> T findObjectByKey(RegistryKey<T> key) {
        Registry registry = (Registry)Registry.field_212617_f.func_82594_a(key.getRegistryName());
        if (registry == null) {
            return null;
        }
        return (T)registry.func_82594_a(key.getRegistryName());
    }
}

