/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data;

import com.sofodev.armorplus.data.Recipes;
import com.sofodev.armorplus.data.recipe.Grid;
import com.sofodev.armorplus.data.recipe.GridInput;
import com.sofodev.armorplus.data.recipe.Input;
import com.sofodev.armorplus.data.recipe.Result;
import com.sofodev.armorplus.utils.DataUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingRecipeMaker
extends RecipeProvider {
    public static final Logger LOGGER = LogManager.getLogger((String)"armorplus");

    public CraftingRecipeMaker(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public static CraftingRecipeMaker get(DataGenerator generator) {
        return new CraftingRecipeMaker(generator);
    }

    public void buildSword(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> sword, IItemProvider material, IItemProvider handle) {
        String path = DataUtils.getPath(sword).replace("item_", "").replace("_sword", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)sword.get(), path + "_swords", path), GridInput.build("M  ", "M  ", "S  ", 'S', 'M'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}));
    }

    public void buildSword(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> sword, IItemProvider material, IItemProvider core, IItemProvider handle) {
        String path = DataUtils.getPath(sword).replace("item_", "").replace("_sword", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)sword.get(), path + "_swords", path), GridInput.build("M  ", "C  ", "S  ", 'S', 'M', 'C'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildSword(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> sword, IItemProvider material, IItemProvider coreA, IItemProvider coreB, IItemProvider coreC, IItemProvider handle) {
        String path = DataUtils.getPath(sword).replace("item_", "").replace("_sword", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)sword.get(), path + "_swords", path), GridInput.build(" M ", "ABC", " S ", 'S', 'M', 'A', 'B', 'C'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreC}));
    }

    public void buildBattleAxe(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> battleAxe, IItemProvider material, IItemProvider handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_battle_axe", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)battleAxe.get(), path + "_battle_axes", path), GridInput.build("M M", "MSM", " S ", 'S', 'M'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}));
    }

    public void buildBattleAxe(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> battleAxe, IItemProvider material, IItemProvider core, IItemProvider handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_battle_axe", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)battleAxe.get(), path + "_battle_axes", path), GridInput.build("M M", "MCM", " S ", 'S', 'M', 'C'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildBattleAxe(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> battleAxe, IItemProvider material, IItemProvider coreA, IItemProvider coreB, IItemProvider coreC, IItemProvider handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_battle_axe", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)battleAxe.get(), path + "_battle_axes", path), GridInput.build("M M", "ABC", " S ", 'S', 'M', 'A', 'B', 'C'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreC}));
    }

    public void buildPickaxe(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> battleAxe, IItemProvider material, IItemProvider handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_pickaxe", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)battleAxe.get(), path + "_pickaxes", path), GridInput.build("MMM", " S ", " S ", 'S', 'M'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}));
    }

    public void buildPickaxe(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> battleAxe, IItemProvider material, IItemProvider core, IItemProvider handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_pickaxe", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)battleAxe.get(), path + "_pickaxes", path), GridInput.build("MMM", " C ", " S ", 'S', 'M', 'C'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildPickaxe(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> battleAxe, IItemProvider material, IItemProvider coreA, IItemProvider coreB, IItemProvider coreC, IItemProvider handle) {
        String path = DataUtils.getPath(battleAxe).replace("item_", "").replace("_pickaxe", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)battleAxe.get(), path + "_pickaxes", path), GridInput.build("AMC", " B ", " S ", 'S', 'M', 'A', 'B', 'C'), handle, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreC}));
    }

    public void buildBow(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> bow, IItemProvider material) {
        String path = DataUtils.getPath(bow).replace("item_", "").replace("_bow", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)bow.get(), path + "_bows", path), GridInput.build("SM ", "S M", "SM ", 'S', 'M'), (IItemProvider)Items.field_151007_F, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}));
        this.build(con, Result.build((IItemProvider)bow.get(), path + "_bows", path).setSuffix("_alt"), GridInput.build(" MS", "M S", " MS", 'S', 'M'), (IItemProvider)Items.field_151007_F, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}));
    }

    public void buildBow(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> bow, IItemProvider core, IItemProvider material) {
        String path = DataUtils.getPath(bow).replace("item_", "").replace("_bow", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)bow.get(), path + "_bows", path), GridInput.build("SM ", "S C", "SM ", 'S', 'M', 'C'), (IItemProvider)Items.field_151007_F, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
        this.build(con, Result.build((IItemProvider)bow.get(), path + "_bows", path).setSuffix("_alt"), GridInput.build(" MS", "C S", " MS", 'S', 'M', 'C'), (IItemProvider)Items.field_151007_F, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildBow(Consumer<IFinishedRecipe> con, RegistryObject<? extends Item> bow, IItemProvider material, IItemProvider coreA, IItemProvider coreB, IItemProvider coreC) {
        String path = DataUtils.getPath(bow).replace("item_", "").replace("_bow", "").replace("_base", "");
        this.build(con, Result.build((IItemProvider)bow.get(), path + "_bows", path), GridInput.build("SAM", "SBM", "SCM", 'S', 'M', 'A', 'B', 'C'), (IItemProvider)Items.field_151007_F, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreC}));
        this.build(con, Result.build((IItemProvider)bow.get(), path + "_bows", path).setSuffix("_alt"), GridInput.build("MAS", "MBS", "MCS", 'S', 'M', 'A', 'B', 'C'), (IItemProvider)Items.field_151007_F, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreC}));
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, String name, IItemProvider material, String itemSuffix) {
        this.buildArmorSet(con, name, material, name, name, "", itemSuffix);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, String name, IItemProvider material, String group, String path, String suffix, String itemSuffix) {
        this.buildArmorSet(con, material, (IItemProvider)Utils.getAPItem(name + "_helmet" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_chestplate" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_leggings" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_boots" + itemSuffix.trim()), group, path, suffix);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, IItemProvider material, IItemProvider head, IItemProvider chest, IItemProvider legs, IItemProvider feet, String group, String path, String suffix) {
        this.buildArmorSet(con, Result.build(head, group, path).setSuffix(suffix), Result.build(chest, group, path).setSuffix(suffix), Result.build(legs, group, path).setSuffix(suffix), Result.build(feet, group, path).setSuffix(suffix), material);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, String name, IItemProvider material, IItemProvider core, String itemSuffix) {
        this.buildArmorSet(con, name, material, core, name, name, "", itemSuffix);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, String name, IItemProvider material, IItemProvider core, String group, String path, String suffix, String itemSuffix) {
        this.buildArmorSet(con, material, core, (IItemProvider)Utils.getAPItem(name + "_helmet" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_chestplate" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_leggings" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_boots" + itemSuffix.trim()), group, path, suffix);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, IItemProvider material, IItemProvider core, IItemProvider head, IItemProvider chest, IItemProvider legs, IItemProvider feet, String group, String path, String suffix) {
        this.buildArmorSet(con, Result.build(head, group, path).setSuffix(suffix), Result.build(chest, group, path).setSuffix(suffix), Result.build(legs, group, path).setSuffix(suffix), Result.build(feet, group, path).setSuffix(suffix), material, core);
    }

    public void buildComplexArmorSet(Consumer<IFinishedRecipe> con, String name, IItemProvider material, String left, String middle, String right, String itemSuffix) {
        this.buildArmorSet(con, name, material, (IItemProvider)Utils.getAPItem(left + "_helmet_base"), (IItemProvider)Utils.getAPItem(middle + "_helmet_base"), (IItemProvider)Utils.getAPItem(right + "_helmet_base"), (IItemProvider)Utils.getAPItem(left + "_chestplate_base"), (IItemProvider)Utils.getAPItem(middle + "_chestplate_base"), (IItemProvider)Utils.getAPItem(right + "_chestplate_base"), (IItemProvider)Utils.getAPItem(left + "_leggings_base"), (IItemProvider)Utils.getAPItem(middle + "_leggings_base"), (IItemProvider)Utils.getAPItem(right + "_leggings_base"), (IItemProvider)Utils.getAPItem(left + "_boots_base"), (IItemProvider)Utils.getAPItem(middle + "_boots_base"), (IItemProvider)Utils.getAPItem(right + "_boots_base"), name, name, "", itemSuffix);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, String name, IItemProvider material, IItemProvider coreHA, IItemProvider coreHB, IItemProvider coreHC, IItemProvider coreCA, IItemProvider coreCB, IItemProvider coreCC, IItemProvider coreLA, IItemProvider coreLB, IItemProvider coreLC, IItemProvider coreBA, IItemProvider coreBB, IItemProvider coreBC, String group, String path, String suffix, String itemSuffix) {
        this.buildArmorSet(con, material, coreHA, coreHB, coreHC, coreCA, coreCB, coreCC, coreLA, coreLB, coreLC, coreBA, coreBB, coreBC, (IItemProvider)Utils.getAPItem(name + "_helmet" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_chestplate" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_leggings" + itemSuffix.trim()), (IItemProvider)Utils.getAPItem(name + "_boots" + itemSuffix.trim()), group, path, suffix);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, IItemProvider material, IItemProvider coreHA, IItemProvider coreHB, IItemProvider coreHC, IItemProvider coreCA, IItemProvider coreCB, IItemProvider coreCC, IItemProvider coreLA, IItemProvider coreLB, IItemProvider coreLC, IItemProvider coreBA, IItemProvider coreBB, IItemProvider coreBC, IItemProvider head, IItemProvider chest, IItemProvider legs, IItemProvider feet, String group, String path, String suffix) {
        this.buildArmorSet(con, Result.build(head, group, path).setSuffix(suffix), Result.build(chest, group, path).setSuffix(suffix), Result.build(legs, group, path).setSuffix(suffix), Result.build(feet, group, path).setSuffix(suffix), material, coreHA, coreHB, coreHC, coreCA, coreCB, coreCC, coreLA, coreLB, coreLC, coreBA, coreBB, coreBC);
    }

    public void buildEnhanced(Consumer<IFinishedRecipe> con, RegistryObject<Item> enMaterial, IItemProvider material) {
        this.buildFilling(con, Result.build((IItemProvider)enMaterial.get(), "ap_en_mats", "enhanced"), material, (IItemProvider)Items.field_151114_aO);
    }

    public void buildSoul(Consumer<IFinishedRecipe> con, RegistryObject<Item> bossSoul, IItemProvider lesserSoul, IItemProvider mat, IItemProvider extra) {
        this.build(con, Result.build((IItemProvider)bossSoul.get(), 1, "ap_souls", "soul"), GridInput.build("ESE", "SXS", "ESE", 'S', 'X', 'E'), lesserSoul, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{mat}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{extra}));
    }

    public void buildOrderedArrow(Consumer<IFinishedRecipe> con, List<RegistryObject<ArrowItem>> arrows) {
        IntStream.range(0, arrows.size()).forEach(i -> this.buildArrow(con, (RegistryObject<ArrowItem>)((RegistryObject)arrows.get(i)), Recipes.MATERIALS_ORDERED.get(i)));
    }

    public void buildArrow(Consumer<IFinishedRecipe> con, RegistryObject<ArrowItem> arrow, IItemProvider material) {
        String path = DataUtils.getPath(arrow).replace("item_", "").replace("_arrow", "");
        String group = "ap_arrows";
        this.buildFilling(con, Result.build((IItemProvider)arrow.get(), 8, group, path), material, (IItemProvider)Items.field_151032_g);
    }

    public void buildColoredBrick(Consumer<IFinishedRecipe> con, RegistryObject<Block> bricks, Tags.IOptionalNamedTag<Item> color) {
        this.buildFilling(con, Result.build((IItemProvider)bricks.get(), 8, "colored_stone_bricks", "bricks"), (IItemProvider)Items.field_221723_cX, Ingredient.func_199805_a(color));
    }

    public void buildStoneBrick(Consumer<IFinishedRecipe> con, RegistryObject<Block> bricks, RegistryObject<Block> tower, RegistryObject<Block> corner, RegistryObject<Block> wall, RegistryObject<Block> stairs, RegistryObject<Block> slab) {
        String group = "stone_brick";
        String pathWall = "wall";
        String pathTower = "tower";
        String pathCorner = "corner";
        String pathStairs = "stairs";
        String pathSlab = "slab";
        this.build(con, Result.build((IItemProvider)corner.get(), 4, this.getGroup("corner"), "corner"), GridInput.build("   ", "S  ", "SSS", 'S'), (IItemProvider)bricks.get());
        this.build(con, Result.build((IItemProvider)wall.get(), 6, this.getGroup("wall"), "wall"), GridInput.build("   ", "SSS", "SSS", 'S'), (IItemProvider)bricks.get());
        this.build(con, Result.build((IItemProvider)tower.get(), 8, this.getGroup("tower"), "tower"), GridInput.build("S S", "SSS", "SSS", 'S'), (IItemProvider)bricks.get());
        this.build(con, Result.build((IItemProvider)stairs.get(), 4, this.getGroup("stairs"), "stairs"), GridInput.build("S  ", "SS ", "SSS", 'S'), (IItemProvider)bricks.get());
        this.build(con, Result.build((IItemProvider)slab.get(), 6, this.getGroup("slab"), "slab"), GridInput.build("   ", "SSS", "   ", 'S'), (IItemProvider)bricks.get());
    }

    private String getGroup(String form) {
        return "stone_brick_" + form;
    }

    public void buildStorage(Consumer<IFinishedRecipe> con, IItemProvider result, IItemProvider item) {
        this.build(con, Result.build(result, 1, "storage", "storage"), GridInput.buildBigSquare('X'), item);
        this.build(con, Result.build(item, 9, "storage", "storage").setSuffix("_to_item"), result);
    }

    public void buildFilling(Consumer<IFinishedRecipe> con, IItemProvider result, IItemProvider center, IItemProvider filler) {
        this.buildFilling(con, Result.build(result), center, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{filler}));
    }

    public void buildFilling(Consumer<IFinishedRecipe> con, IItemProvider result, int count, IItemProvider center, IItemProvider filler) {
        this.buildFilling(con, Result.build(result, count), center, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{filler}));
    }

    public void buildFilling(Consumer<IFinishedRecipe> con, Result result, IItemProvider center, IItemProvider filler) {
        this.buildFilling(con, result, center, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{filler}));
    }

    public void buildFilling(Consumer<IFinishedRecipe> con, Result result, IItemProvider center, Ingredient filler) {
        this.build(con, result, GridInput.build("SSS", "SXS", "SSS", 'X', 'S'), center, filler);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, Result head, Result chest, Result legs, Result feet, IItemProvider material) {
        this.buildHelmet(con, head, material);
        this.buildChestplate(con, chest, material);
        this.buildLeggings(con, legs, material);
        this.buildBoots(con, feet, material);
    }

    public void buildHelmet(Consumer<IFinishedRecipe> con, Result result, IItemProvider material) {
        this.build(con, result, GridInput.build("SSS", "S S", 'S'), material);
        this.build(con, result.setSuffix("_alt"), GridInput.build("   ", "SSS", "S S", 'S'), material);
    }

    public void buildChestplate(Consumer<IFinishedRecipe> con, Result result, IItemProvider material) {
        this.build(con, result, GridInput.build("S S", "SSS", "SSS", 'S'), material);
    }

    public void buildLeggings(Consumer<IFinishedRecipe> con, Result result, IItemProvider material) {
        this.build(con, result, GridInput.build("SSS", "S S", "S S", 'S'), material);
    }

    public void buildBoots(Consumer<IFinishedRecipe> con, Result result, IItemProvider material) {
        this.build(con, result, GridInput.build("S S", "S S", 'S'), material);
        this.build(con, result.setSuffix("_alt"), GridInput.build("   ", "S S", "S S", 'S'), material);
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, Result head, Result chest, Result legs, Result feet, IItemProvider material, IItemProvider core) {
        this.buildHelmet(con, head, material, core);
        this.buildChestplate(con, chest, material, core);
        this.buildLeggings(con, legs, material, core);
        this.buildBoots(con, feet, material, core);
    }

    public void buildHelmet(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider core) {
        this.build(con, result, GridInput.build("SCS", "S S", 'S', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
        this.build(con, result.setSuffix("_alt"), GridInput.build("   ", "SCS", "S S", 'S', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildChestplate(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider core) {
        this.build(con, result, GridInput.build("S S", "SCS", "SSS", 'S', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildLeggings(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider core) {
        this.build(con, result, GridInput.build("SCS", "S S", "S S", 'S', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildBoots(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider core) {
        this.build(con, result, GridInput.build("S S", "SCS", 'S', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
        this.build(con, result.setSuffix("_alt"), GridInput.build("   ", "S S", "SCS", 'S', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{core}));
    }

    public void buildArmorSet(Consumer<IFinishedRecipe> con, Result head, Result chest, Result legs, Result feet, IItemProvider material, IItemProvider coreHA, IItemProvider coreHB, IItemProvider coreHC, IItemProvider coreCA, IItemProvider coreCB, IItemProvider coreCC, IItemProvider coreLA, IItemProvider coreLB, IItemProvider coreLC, IItemProvider coreBA, IItemProvider coreBB, IItemProvider coreBC) {
        this.buildHelmet(con, head, material, coreHA, coreHB, coreHC);
        this.buildChestplate(con, chest, material, coreCA, coreCB, coreCC);
        this.buildLeggings(con, legs, material, coreLA, coreLB, coreLC);
        this.buildBoots(con, feet, material, coreBA, coreBB, coreBC);
    }

    public void buildHelmet(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider coreHA, IItemProvider coreHB, IItemProvider coreHC) {
        this.build(con, result, GridInput.build("ABC", "S S", 'S', 'A', 'B', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreHA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreHB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreHC}));
        this.build(con, result.setSuffix("_alt"), GridInput.build("   ", "ABC", "S S", 'S', 'A', 'B', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreHA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreHB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreHC}));
    }

    public void buildChestplate(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider coreCA, IItemProvider coreCB, IItemProvider coreCC) {
        this.build(con, result, GridInput.build("A C", "SBS", "SSS", 'S', 'A', 'B', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreCA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreCB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreCC}));
    }

    public void buildLeggings(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider coreLA, IItemProvider coreLB, IItemProvider coreLC) {
        this.build(con, result, GridInput.build("ABC", "S S", "S S", 'S', 'A', 'B', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreLA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreLB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreLC}));
    }

    public void buildBoots(Consumer<IFinishedRecipe> con, Result result, IItemProvider material, IItemProvider coreBA, IItemProvider coreBB, IItemProvider coreBC) {
        this.build(con, result, GridInput.build("S S", "ABC", 'S', 'A', 'B', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreBA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreBB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreBC}));
        this.build(con, result.setSuffix("_alt"), GridInput.build("   ", "S S", "ABC", 'S', 'A', 'B', 'C'), material, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreBA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreBB}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coreBC}));
    }

    public void build(Consumer<IFinishedRecipe> consumer, Result result, GridInput layout, IItemProvider mainInput, Ingredient ... additional) {
        HashMap arrangedGrid = new HashMap();
        String path = DataUtils.getPath(result.getObject());
        Grid grid = layout.getGrid();
        Input input = layout.getSimpleInput();
        this.logGrid(result, path, grid);
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.func_200468_a((IItemProvider)result.getObject(), (int)result.getCount());
        builder.func_200472_a(grid.getFirstRow());
        builder.func_200472_a(grid.getSecondRow());
        builder.func_200472_a(grid.getThirdRow());
        builder.func_200462_a(Character.valueOf(input.getA()), mainInput);
        IntStream.range(0, additional.length).forEach(i -> this.addIngredients(builder, input.getCharList().get(i + 1).charValue(), additional[i]));
        builder.func_200473_b(Utils.setLocation(result.getGroup().orElse(path)));
        builder.func_200465_a("has_req", (ICriterionInstance)CraftingRecipeMaker.func_200403_a((IItemProvider)mainInput));
        builder.func_200467_a(consumer, Utils.setRL("crafting/shaped/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    public void build(Consumer<IFinishedRecipe> con, Result result, GridInput layout, IItemProvider input) {
        this.build(con, result, layout, input, Ingredient.field_193370_a);
    }

    public void build(Consumer<IFinishedRecipe> consumer, Result result, GridInput layout, IItemProvider ... inputs) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.func_200468_a((IItemProvider)result.getObject(), (int)result.getCount());
        String path = DataUtils.getPath(result.getObject());
        Grid grid = layout.getGrid();
        Input input = layout.getSimpleInput();
        this.logGrid(result, path, grid);
        builder.func_200472_a(grid.getFirstRow());
        builder.func_200472_a(grid.getSecondRow());
        builder.func_200472_a(grid.getThirdRow());
        IntStream.range(0, inputs.length).forEach(i -> this.addIngredients(builder, input.getCharList().get(i).charValue(), inputs[i]));
        boolean hasGroup = result.getGroup().isPresent();
        if (hasGroup) {
            builder.func_200473_b(Utils.setLocation(result.getGroup().get()));
        }
        builder.func_200465_a("has_req", (ICriterionInstance)CraftingRecipeMaker.func_200403_a((IItemProvider)inputs[0]));
        builder.func_200467_a(consumer, Utils.setRL("crafting/shaped/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    private void logGrid(Result result, String path, Grid grid) {
        LOGGER.info("Item: {}, count: {}", (Object)path, (Object)result.getCount());
        LOGGER.info("Building Pattern: [{}]", (Object)grid.getFirstRow());
        LOGGER.info("Building Pattern: [{}]", (Object)grid.getSecondRow());
        LOGGER.info("Building Pattern: [{}]", (Object)grid.getThirdRow());
    }

    private void addIngredients(ShapedRecipeBuilder builder, char character, Ingredient input) {
        if (!input.isSimple()) {
            builder.func_200471_a(Character.valueOf(character), input);
        }
    }

    private void addIngredients(ShapedRecipeBuilder builder, char character, IItemProvider input) {
        builder.func_200462_a(Character.valueOf(character), input);
    }

    public void build(Consumer<IFinishedRecipe> con, Result result, IItemProvider item) {
        this.build(con, result, item, Ingredient.field_193370_a);
    }

    public void build(Consumer<IFinishedRecipe> con, Result result, IItemProvider inputA, Ingredient ... inputs) {
        String path = DataUtils.getPath(result.getObject());
        LOGGER.info("Item: {}, count: {}", (Object)path, (Object)result.getCount());
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.func_200488_a((IItemProvider)result.getObject(), (int)result.getCount());
        builder.func_200487_b(inputA);
        Arrays.stream(inputs).forEach(ingredient -> this.addIngredients(builder, (Ingredient)ingredient));
        boolean hasGroup = result.getGroup().isPresent();
        if (hasGroup) {
            builder.func_200490_a(Utils.setLocation(result.getGroup().get()));
        }
        builder.func_200483_a("has_req", (ICriterionInstance)CraftingRecipeMaker.func_200403_a((IItemProvider)inputA));
        builder.func_200485_a(con, Utils.setRL("crafting/shapeless/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    public void build(Consumer<IFinishedRecipe> con, Result result, IItemProvider ... item) {
        String path = DataUtils.getPath(result.getObject());
        LOGGER.info("Item: {}, count: {}", (Object)path, (Object)result.getCount());
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.func_200488_a((IItemProvider)result.getObject(), (int)result.getCount());
        Arrays.stream(item).forEach(ingredient -> this.addIngredients(builder, (IItemProvider)ingredient));
        boolean hasGroup = result.getGroup().isPresent();
        if (hasGroup) {
            builder.func_200490_a(Utils.setLocation(result.getGroup().get()));
        }
        builder.func_200483_a("has_req", (ICriterionInstance)CraftingRecipeMaker.func_200403_a((IItemProvider)item[0]));
        builder.func_200485_a(con, Utils.setRL("crafting/shapeless/" + result.getPath().orElse("").trim() + result.getPrefix() + path + result.getSuffix()));
    }

    private void addIngredients(ShapelessRecipeBuilder builder, Ingredient input) {
        if (!input.isSimple()) {
            builder.func_200489_a(input);
        }
    }

    private void addIngredients(ShapelessRecipeBuilder builder, IItemProvider input) {
        builder.func_200487_b(input);
    }
}

