/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data;

import com.sofodev.armorplus.data.BaseLootTableProvider;
import com.sofodev.armorplus.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class LootTables
extends BaseLootTableProvider {
    public List<RegistryObject<Block>> blockList = new ArrayList<RegistryObject<Block>>();

    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Override
    protected void addTables() {
        this.blockList.addAll(ModBlocks.blocks);
        this.removeEntries(ModBlocks.ORE_FROST_CRYSTAL, ModBlocks.ORE_FROST_CRYSTAL_STONE, ModBlocks.ORE_FROST_CRYSTAL_OBSIDIAN, ModBlocks.ORE_LAVA_CRYSTAL, ModBlocks.ORE_LAVA_CRYSTAL_STONE, ModBlocks.ORE_LAVA_CRYSTAL_OBSIDIAN);
        this.blockList.stream().map(RegistryObject::get).forEach(this::registerDropSelfLootTable);
    }

    @SafeVarargs
    public final void removeEntries(RegistryObject<Block> ... specialBlocks) {
        Arrays.stream(specialBlocks).forEach(block -> this.blockList.remove(block));
    }

    protected void registerLootTable(Block block, LootTable.Builder table) {
        this.lootTables.put(block, table);
    }

    protected static LootTable.Builder dropping(IItemProvider block) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)));
    }

    public void registerDropping(Block block, IItemProvider drop) {
        this.registerLootTable(block, LootTables.dropping(drop));
    }

    public void registerDropSelfLootTable(Block block) {
        this.registerDropping(block, (IItemProvider)block);
    }

    public void registerStandardTable(String name, Block block) {
        this.registerLootTable(block, this.createStandardTable(name, block));
    }

    protected static LootTable.Builder droppingWithContents(Block block, ResourceLocation key) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Lock", "BlockEntityTag.Lock").func_216056_a("LootTable", "BlockEntityTag.LootTable").func_216056_a("LootTableSeed", "BlockEntityTag.LootTableSeed")).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)key)))));
    }
}

