/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.data.CraftingRecipeMaker;
import com.sofodev.armorplus.data.SmithingRecipeMaker;
import com.sofodev.armorplus.data.recipe.Grid;
import com.sofodev.armorplus.data.recipe.GridInput;
import com.sofodev.armorplus.data.recipe.Result;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.utils.DataUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Recipes
extends RecipeProvider
implements IDataProvider,
IConditionBuilder {
    public static final List<Tags.IOptionalNamedTag<Item>> BRICK_COLORS = Stream.of(Tags.Items.DYES_BLACK, Tags.Items.DYES_BLUE, Tags.Items.DYES_GREEN, Tags.Items.DYES_PURPLE, Tags.Items.DYES_RED, Tags.Items.DYES_WHITE, Tags.Items.DYES_YELLOW, Tags.Items.DYES_ORANGE).collect(Collectors.toList());
    public static final List<IItemProvider> MATERIALS_ORDERED = Stream.of(Items.field_151044_h, Items.field_151137_ax, Items.field_196128_bn, Items.field_151166_bC, Items.field_221655_bP, (Item)ModItems.INFUSED_LAVA_CRYSTAL.get(), (Item)ModItems.GUARDIAN_SCALE.get(), (Item)ModItems.WITHER_BONE.get(), (Item)ModItems.ENDER_DRAGON_SCALE.get()).collect(Collectors.toList());
    public static final List<IItemProvider> BLOCK_MATERIALS_ORDERED = Stream.of(Items.field_221896_ff, Items.field_221858_em, Items.field_221654_ao, Items.field_221739_dF, (ForgeRegistryEntry)ModBlocks.COMPRESSED_OBSIDIAN.get(), (ForgeRegistryEntry)ModItems.INFUSED_LAVA_CRYSTAL.get(), (ForgeRegistryEntry)ModItems.GUARDIAN_SCALE.get(), (ForgeRegistryEntry)ModItems.WITHER_BONE.get(), (ForgeRegistryEntry)ModItems.ENDER_DRAGON_SCALE.get()).collect(Collectors.toList());
    public static final List<IItemProvider> LOW_TO_MID_TIER_MATERIAL_LIST = Stream.of(Items.field_221896_ff, Items.field_221858_em, Items.field_221654_ao, Items.field_221739_dF, (ForgeRegistryEntry)ModBlocks.COMPRESSED_OBSIDIAN.get()).collect(Collectors.toList());

    public Recipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> con) {
        this.registerCraftingRecipes(con);
        this.registerSmithingRecipes(con);
    }

    private void registerCraftingRecipes(Consumer<IFinishedRecipe> con) {
        int i2;
        CraftingRecipeMaker crafter = new CraftingRecipeMaker(this.field_200413_c);
        int l = ArmorPlus.AP_STONE_BRICKS_LENGTH;
        for (i2 = 0; i2 < l; ++i2) {
            crafter.buildStoneBrick(con, ModBlocks.CASTLE_BLOCKS[i2], ModBlocks.CASTLE_BLOCK_TOWERS[i2], ModBlocks.CASTLE_BLOCK_CORNERS[i2], ModBlocks.CASTLE_BLOCK_WALLS[i2], ModBlocks.CASTLE_BLOCK_STAIRS[i2], ModBlocks.CASTLE_BLOCK_SLABS[i2]);
        }
        for (i2 = 0; i2 < l; ++i2) {
            crafter.buildStoneBrick(con, ModBlocks.STONE_BRICKS[i2], ModBlocks.STONE_BRICK_TOWERS[i2], ModBlocks.STONE_BRICK_CORNERS[i2], ModBlocks.STONE_BRICK_WALLS[i2], ModBlocks.STONE_BRICK_STAIRS[i2], ModBlocks.STONE_BRICK_SLABS[i2]);
        }
        for (i2 = 0; i2 < l; ++i2) {
            crafter.buildColoredBrick(con, ModBlocks.STONE_BRICKS[i2], BRICK_COLORS.get(i2));
        }
        for (i2 = 0; i2 < ArmorPlus.AP_TOOL_MATERIAL_LENGTH - 5; ++i2) {
            crafter.buildSword(con, ModItems.SWORDS[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2), (IItemProvider)Items.field_151055_y);
            crafter.buildBattleAxe(con, ModItems.BATTLE_AXES[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2), (IItemProvider)Items.field_151055_y);
            crafter.buildPickaxe(con, ModItems.PICKAXES[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2), (IItemProvider)Items.field_151055_y);
            crafter.buildBow(con, ModItems.BOWS[i2], LOW_TO_MID_TIER_MATERIAL_LIST.get(i2));
        }
        int lava = ArmorPlus.AP_TOOL_MATERIAL_LENGTH - 5;
        crafter.buildSword(con, ModItems.SWORDS[lava], (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get(), (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.BATTLE_AXES[lava], (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get(), (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.PICKAXES[lava], (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get(), (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBow(con, ModItems.BOWS[lava], (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get());
        crafter.buildSword(con, ModItems.GUARDIAN_SWORD_BASE, (IItemProvider)ModItems.GUARDIAN_SCALE.get(), (IItemProvider)Items.field_221879_fX, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildSword(con, ModItems.SUPER_STAR_SWORD_BASE, (IItemProvider)ModItems.WITHER_BONE.get(), (IItemProvider)Items.field_151156_bN, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildSword(con, ModItems.ENDER_DRAGON_SWORD_BASE, (IItemProvider)ModItems.ENDER_DRAGON_SCALE.get(), (IItemProvider)Items.field_185157_bK, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.GUARDIAN_BATTLE_AXE_BASE, (IItemProvider)ModItems.GUARDIAN_SCALE.get(), (IItemProvider)Items.field_221879_fX, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.SUPER_STAR_BATTLE_AXE_BASE, (IItemProvider)ModItems.WITHER_BONE.get(), (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.ENDER_DRAGON_BATTLE_AXE_BASE, (IItemProvider)ModItems.ENDER_DRAGON_SCALE.get(), (IItemProvider)Items.field_185157_bK, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.GUARDIAN_PICKAXE_BASE, (IItemProvider)ModItems.GUARDIAN_SCALE.get(), (IItemProvider)Items.field_221879_fX, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.SUPER_STAR_PICKAXE_BASE, (IItemProvider)ModItems.WITHER_BONE.get(), (IItemProvider)Items.field_151156_bN, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.ENDER_DRAGON_PICKAXE_BASE, (IItemProvider)ModItems.ENDER_DRAGON_SCALE.get(), (IItemProvider)Items.field_185157_bK, (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBow(con, ModItems.GUARDIAN_BOW_BASE, (IItemProvider)Items.field_221879_fX, (IItemProvider)ModItems.GUARDIAN_SCALE.get());
        crafter.buildBow(con, ModItems.SUPER_STAR_BOW_BASE, (IItemProvider)Items.field_151156_bN, (IItemProvider)ModItems.WITHER_BONE.get());
        crafter.buildBow(con, ModItems.ENDER_DRAGON_BOW_BASE, (IItemProvider)Items.field_185157_bK, (IItemProvider)ModItems.ENDER_DRAGON_SCALE.get());
        crafter.buildOrderedArrow(con, Arrays.asList(ModItems.ITEM_COAL_ARROW, ModItems.ITEM_REDSTONE_ARROW, ModItems.ITEM_LAPIS_ARROW, ModItems.ITEM_EMERALD_ARROW, ModItems.ITEM_OBSIDIAN_ARROW, ModItems.ITEM_INFUSED_LAVA_ARROW, ModItems.ITEM_GUARDIAN_ARROW, ModItems.ITEM_SUPER_STAR_ARROW, ModItems.ITEM_ENDER_DRAGON_ARROW));
        crafter.buildSoul(con, ModItems.WITHER_BOSS_SOUL, (IItemProvider)ModItems.WITHER_SKELETON_SOUL.get(), (IItemProvider)ModItems.WITHER_BONE.get(), (IItemProvider)Items.field_221693_cI);
        crafter.buildSoul(con, ModItems.ELDER_GUARDIAN_SOUL, (IItemProvider)ModItems.GUARDIAN_SOUL.get(), (IItemProvider)ModItems.GUARDIAN_SCALE.get(), (IItemProvider)Items.field_221879_fX);
        crafter.buildSoul(con, ModItems.ENDER_DRAGON_SOUL, (IItemProvider)ModItems.ENDERMAN_SOUL.get(), (IItemProvider)ModItems.ENDER_DRAGON_SCALE.get(), (IItemProvider)Items.field_221828_dx);
        crafter.buildEnhanced(con, ModItems.ENHANCED_CHAINMAIL, (IItemProvider)ModItems.CHAINMAIL.get());
        crafter.buildEnhanced(con, ModItems.ENHANCED_IRON, (IItemProvider)Items.field_151042_j);
        crafter.buildEnhanced(con, ModItems.ENHANCED_GOLD, (IItemProvider)Items.field_151043_k);
        crafter.buildEnhanced(con, ModItems.ENHANCED_DIAMOND, (IItemProvider)Items.field_151045_i);
        crafter.buildEnhanced(con, ModItems.ENHANCED_NETHERITE, (IItemProvider)Items.field_234759_km_);
        String enGroup = "ap_en_";
        String enPath = "enhanced";
        crafter.buildArmorSet(con, "chainmail", (IItemProvider)ModItems.ENHANCED_CHAINMAIL.get(), enGroup + "chainmail", enPath, "", "");
        crafter.buildArmorSet(con, "iron", (IItemProvider)ModItems.ENHANCED_IRON.get(), enGroup + "iron", enPath, "", "");
        crafter.buildArmorSet(con, "golden", (IItemProvider)ModItems.ENHANCED_GOLD.get(), enGroup + "gold", enPath, "", "");
        crafter.buildArmorSet(con, "diamond", (IItemProvider)ModItems.ENHANCED_DIAMOND.get(), enGroup + "diamond", enPath, "", "");
        crafter.buildArmorSet(con, "chicken", (IItemProvider)Items.field_151008_G, "");
        crafter.buildArmorSet(con, "slime", (IItemProvider)Items.field_221904_fj, "");
        crafter.buildArmorSet(con, "coal", (IItemProvider)Items.field_221896_ff, "");
        crafter.buildArmorSet(con, "lapis", (IItemProvider)Items.field_221654_ao, "");
        crafter.buildArmorSet(con, "redstone", (IItemProvider)Items.field_221858_em, "");
        crafter.buildArmorSet(con, "emerald", (IItemProvider)Items.field_221739_dF, "");
        crafter.buildArmorSet(con, "obsidian", (IItemProvider)ModBlocks.COMPRESSED_OBSIDIAN.get(), "");
        crafter.buildArmorSet(con, "infused_lava", (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get(), "");
        crafter.buildArmorSet(con, "guardian", (IItemProvider)ModItems.GUARDIAN_SCALE.get(), (IItemProvider)Items.field_221879_fX, "_base");
        crafter.buildArmorSet(con, "super_star", (IItemProvider)ModItems.WITHER_BONE.get(), (IItemProvider)Items.field_151156_bN, "_base");
        crafter.buildArmorSet(con, "ender_dragon", (IItemProvider)ModItems.ENDER_DRAGON_SCALE.get(), (IItemProvider)Items.field_185157_bK, "_base");
        crafter.buildArmorSet(con, "frost", (IItemProvider)ModItems.INFUSED_FROST_CRYSTAL.get(), "");
        crafter.buildArmorSet(con, "frost_lava", (IItemProvider)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get(), "");
        int bound = ModItems.MACES.length - 1;
        IntStream.range(0, bound).forEach(i -> {
            Item mace = (Item)ModItems.MACES[i].get();
            String path = DataUtils.getPath((IItemProvider)mace).replace("item_", "").replace("_mace", "");
            IItemProvider material = BLOCK_MATERIALS_ORDERED.get(i);
            crafter.build(con, Result.build((IItemProvider)mace, "maces", path), GridInput.build(" DD", " SD", "S  ", 'S', 'D'), i > 4 ? (IItemProvider)ModItems.OBSIDIAN_STICK.get() : (IItemProvider)ModItems.WOODEN_ROD.get(), material);
            crafter.build(con, Result.build((IItemProvider)mace, "maces", path).setSuffix("_alt"), GridInput.build("DD ", "DS ", "  S", 'S', 'D'), i > 4 ? (IItemProvider)ModItems.OBSIDIAN_STICK.get() : (IItemProvider)ModItems.WOODEN_ROD.get(), material);
        });
        crafter.buildStorage(con, (IItemProvider)ModBlocks.COMPRESSED_LAVA_CRYSTAL.get(), (IItemProvider)ModBlocks.LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (IItemProvider)ModBlocks.LAVA_CRYSTAL.get(), (IItemProvider)ModItems.LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (IItemProvider)ModBlocks.COMPRESSED_INFUSED_LAVA_CRYSTAL.get(), (IItemProvider)ModBlocks.INFUSED_LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (IItemProvider)ModBlocks.INFUSED_LAVA_CRYSTAL.get(), (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get());
        crafter.buildStorage(con, (IItemProvider)ModBlocks.COMPRESSED_OBSIDIAN.get(), (IItemProvider)Items.field_221655_bP);
        crafter.buildStorage(con, (IItemProvider)ModItems.LAVA_CRYSTAL.get(), (IItemProvider)ModItems.LAVA_SHARD.get());
        crafter.buildStorage(con, (IItemProvider)ModItems.FROST_CRYSTAL.get(), (IItemProvider)ModItems.FROST_SHARD.get());
        crafter.build(con, Result.build((IItemProvider)ModItems.THE_ULTIMATE_MATERIAL.get(), 1), (IItemProvider)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get(), (IItemProvider)ModItems.WITHER_BONE.get(), (IItemProvider)ModItems.ENDER_DRAGON_SCALE.get(), (IItemProvider)ModItems.GUARDIAN_SCALE.get());
        crafter.buildComplexArmorSet(con, "slayer", (IItemProvider)ModItems.THE_ULTIMATE_MATERIAL.get(), "super_star", "ender_dragon", "guardian", "_base");
        crafter.buildSword(con, ModItems.SLAYER_SWORD_BASE, (IItemProvider)ModItems.THE_ULTIMATE_MATERIAL.get(), (IItemProvider)ModItems.SUPER_STAR_SWORD_BASE.get(), (IItemProvider)ModItems.ENDER_DRAGON_SWORD_BASE.get(), (IItemProvider)ModItems.GUARDIAN_SWORD_BASE.get(), (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBattleAxe(con, ModItems.SLAYER_BATTLE_AXE_BASE, (IItemProvider)ModItems.THE_ULTIMATE_MATERIAL.get(), (IItemProvider)ModItems.SUPER_STAR_BATTLE_AXE_BASE.get(), (IItemProvider)ModItems.ENDER_DRAGON_BATTLE_AXE_BASE.get(), (IItemProvider)ModItems.GUARDIAN_BATTLE_AXE_BASE.get(), (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildPickaxe(con, ModItems.SLAYER_PICKAXE_BASE, (IItemProvider)ModItems.THE_ULTIMATE_MATERIAL.get(), (IItemProvider)ModItems.SUPER_STAR_PICKAXE_BASE.get(), (IItemProvider)ModItems.ENDER_DRAGON_PICKAXE_BASE.get(), (IItemProvider)ModItems.GUARDIAN_PICKAXE_BASE.get(), (IItemProvider)ModItems.OBSIDIAN_STICK.get());
        crafter.buildBow(con, ModItems.SLAYER_BOW_BASE, (IItemProvider)ModItems.THE_ULTIMATE_MATERIAL.get(), (IItemProvider)ModItems.SUPER_STAR_BOW_BASE.get(), (IItemProvider)ModItems.ENDER_DRAGON_BOW_BASE.get(), (IItemProvider)ModItems.GUARDIAN_BOW_BASE.get());
        crafter.build(con, Result.build((IItemProvider)ModItems.SLAYER_SOUL.get(), 1).setGroup("slayer").setSuffix(""), (IItemProvider)ModItems.ELDER_GUARDIAN_SOUL.get(), (IItemProvider)ModItems.WITHER_BOSS_SOUL.get(), (IItemProvider)ModItems.ENDER_DRAGON_SOUL.get());
        crafter.build(con, Result.build((IItemProvider)ModBlocks.SOUL_BOX.get()).setGroup("villager").setSuffix(""), GridInput.build("ASA", "SGS", "ASA", 'A', 'S', 'G'), new IItemProvider[]{Items.field_221574_b, Items.field_221693_cI, Items.field_221695_cJ});
        crafter.build(con, Result.build((IItemProvider)ModItems.OBSIDIAN_STICK.get(), 4).setGroup("materials").setSuffix(""), GridInput.build(Grid.build("X", "X", " "), 'X'), (IItemProvider)Items.field_221655_bP);
        crafter.build(con, Result.build((IItemProvider)ModItems.WOODEN_ROD.get(), 2).setGroup("materials").setSuffix(""), new IItemProvider[]{Items.field_151055_y, Items.field_151055_y, Items.field_151055_y, Items.field_151055_y});
        crafter.build(con, Result.build((IItemProvider)ModBlocks.SNOW_BRICK.get(), 4).setGroup("snow_brick").setSuffix(""), GridInput.buildSmallSquare('X'), (IItemProvider)Items.field_221772_cv);
        crafter.build(con, Result.build((IItemProvider)ModBlocks.SNOW_BRICK_STAIRS.get(), 4).setGroup("snow_brick_stairs").setSuffix(""), GridInput.buildStairs('X'), (IItemProvider)ModBlocks.SNOW_BRICK.get());
        crafter.build(con, Result.build((IItemProvider)ModBlocks.SNOW_BRICK_SLAB.get(), 4).setGroup("snow_brick_slab").setSuffix(""), GridInput.buildSlab('X'), (IItemProvider)ModBlocks.SNOW_BRICK.get());
    }

    private void registerSmithingRecipes(Consumer<IFinishedRecipe> con) {
        SmithingRecipeMaker smither = new SmithingRecipeMaker(this.field_200413_c);
        smither.buildBaseToFullSmithing(con, ModItems.SUPER_STAR_BASES, (IItemProvider)ModItems.WITHER_BOSS_SOUL.get());
        smither.buildBaseToFullSmithing(con, ModItems.GUARDIAN_BASES, (IItemProvider)ModItems.ELDER_GUARDIAN_SOUL.get());
        smither.buildBaseToFullSmithing(con, ModItems.ENDER_DRAGON_BASES, (IItemProvider)ModItems.ENDER_DRAGON_SOUL.get());
        smither.buildBaseToFullSmithing(con, ModItems.SLAYER_BASES, (IItemProvider)ModItems.SLAYER_SOUL.get());
        smither.buildBaseToFullSmithing(con, (IItemProvider)ModItems.WITHER_BOSS_SOUL.get(), ModItems.SUPER_STAR_SWORD_BASE, ModItems.SUPER_STAR_BATTLE_AXE_BASE, ModItems.SUPER_STAR_PICKAXE_BASE, ModItems.SUPER_STAR_BOW_BASE);
        smither.buildBaseToFullSmithing(con, (IItemProvider)ModItems.ELDER_GUARDIAN_SOUL.get(), ModItems.GUARDIAN_SWORD_BASE, ModItems.GUARDIAN_BATTLE_AXE_BASE, ModItems.GUARDIAN_PICKAXE_BASE, ModItems.GUARDIAN_BOW_BASE);
        smither.buildBaseToFullSmithing(con, (IItemProvider)ModItems.ENDER_DRAGON_SOUL.get(), ModItems.ENDER_DRAGON_SWORD_BASE, ModItems.ENDER_DRAGON_BATTLE_AXE_BASE, ModItems.ENDER_DRAGON_PICKAXE_BASE, ModItems.ENDER_DRAGON_BOW_BASE);
        smither.buildBaseToFullSmithing(con, (IItemProvider)ModItems.SLAYER_SOUL.get(), ModItems.SLAYER_SWORD_BASE, ModItems.SLAYER_BATTLE_AXE_BASE, ModItems.SLAYER_PICKAXE_BASE, ModItems.SLAYER_BOW_BASE);
        smither.buildVanillaToEnhancedSmithing(con, (IItemProvider)Items.field_234763_ls_, ModItems.ENHANCED_NETHERITE);
        smither.buildVanillaToEnhancedSmithing(con, (IItemProvider)Items.field_234764_lt_, ModItems.ENHANCED_NETHERITE);
        smither.buildVanillaToEnhancedSmithing(con, (IItemProvider)Items.field_234765_lu_, ModItems.ENHANCED_NETHERITE);
        smither.buildVanillaToEnhancedSmithing(con, (IItemProvider)Items.field_234766_lv_, ModItems.ENHANCED_NETHERITE);
        smither.buildSmithing(con, (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get(), (IItemProvider)ModItems.INFUSED_FROST_CRYSTAL.get(), (IItemProvider)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get());
        smither.buildSmithing(con, (IItemProvider)ModItems.INFUSED_FROST_CRYSTAL.get(), (IItemProvider)ModItems.INFUSED_LAVA_CRYSTAL.get(), (IItemProvider)ModItems.INFUSED_FROST_LAVA_CRYSTAL.get());
    }

    public String func_200397_b() {
        return "Recipes";
    }
}

