/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data;

import com.sofodev.armorplus.utils.DataUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.SmithingRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.RegistryObject;

public class SmithingRecipeMaker
extends RecipeProvider {
    public SmithingRecipeMaker(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public static SmithingRecipeMaker get(DataGenerator generator) {
        return new SmithingRecipeMaker(generator);
    }

    public void buildBaseToFullSmithing(Consumer<IFinishedRecipe> consumer, Set<RegistryObject<Item>> bases, IItemProvider soul) {
        bases.forEach(base -> this.buildBaseToFullSmithing(consumer, (RegistryObject<Item>)base, soul));
    }

    public void buildBaseToFullSmithing(Consumer<IFinishedRecipe> consumer, RegistryObject<Item> base, IItemProvider soul) {
        this.buildSmithing(consumer, (IItemProvider)base.get(), soul, (IItemProvider)DataUtils.quickModLookupItem(base.getId()));
    }

    @SafeVarargs
    public final void buildBaseToFullSmithing(Consumer<IFinishedRecipe> consumer, IItemProvider soul, RegistryObject<Item> ... bases) {
        Arrays.stream(bases).forEach(base -> this.buildSmithing(consumer, (IItemProvider)base.get(), soul, (IItemProvider)DataUtils.quickModLookupItem(base.getId())));
    }

    public void buildVanillaToEnhancedSmithing(Consumer<IFinishedRecipe> consumer, IItemProvider vanilla, RegistryObject<Item> mat) {
        this.buildSmithing(consumer, vanilla, (IItemProvider)mat.get(), (IItemProvider)Utils.getAPItem(DataUtils.getPath(vanilla)));
    }

    public void buildSmithing(Consumer<IFinishedRecipe> consumer, IItemProvider base, IItemProvider addition, IItemProvider result) {
        String path = DataUtils.getPath(base);
        SmithingRecipeBuilder.func_240502_a_((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{base}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{addition}), (Item)result.func_199767_j()).func_240503_a_("has_req", (ICriterionInstance)SmithingRecipeMaker.func_200403_a((IItemProvider)addition)).func_240505_a_(consumer, Utils.setRL("smithing/" + path));
    }
}

