/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data.caps;

import com.sofodev.armorplus.registry.items.special.Element;
import com.sofodev.armorplus.utils.Utils;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CapabilityElementalMastery {
    @CapabilityInject(value=IElementalMastery.class)
    public static Capability<IElementalMastery> CAPABILITY_ELEMENTAL_MASTERY;

    public static void register() {
        CapabilityManager.INSTANCE.register(IElementalMastery.class, (Capability.IStorage)new Capability.IStorage<IElementalMastery>(){

            @Nullable
            public INBT writeNBT(Capability<IElementalMastery> capability, IElementalMastery instance, Direction side) {
                throw new RuntimeException("Use com.sofodev.armorplus.data.caps.CapabilityElementalMastery.Provider instead");
            }

            public void readNBT(Capability<IElementalMastery> capability, IElementalMastery instance, Direction side, INBT nbt) {
                throw new RuntimeException("Use com.sofodev.armorplus.data.caps.CapabilityElementalMastery.Provider instead");
            }
        }, Implementation::new);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityElementalMastery());
    }

    public static IElementalMastery getHandler(ItemStack stack) {
        return (IElementalMastery)stack.getCapability(CAPABILITY_ELEMENTAL_MASTERY).map(handler -> handler).orElseThrow(() -> new RuntimeException("No Capability"));
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(Utils.setRL("elemental_mastery"), (ICapabilityProvider)new Provider());
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        LazyOptional<IElementalMastery> instance = LazyOptional.of(Implementation::new);

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            IElementalMastery mastery = (IElementalMastery)this.instance.orElseThrow(() -> new RuntimeException("No Capability"));
            if (this.instance != null) {
                tag.func_74778_a("primary", mastery.getPrimary().getName());
                tag.func_74778_a("secondary", mastery.getSecondary().getName());
            }
            return tag;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            IElementalMastery mastery = (IElementalMastery)this.instance.orElseThrow(() -> new RuntimeException("No Capability"));
            Element primary = Element.valueOf(nbt.func_74779_i("primary").toUpperCase(Locale.ENGLISH));
            Element secondary = Element.valueOf(nbt.func_74779_i("secondary").toUpperCase(Locale.ENGLISH));
            mastery.setPrimary(primary);
            mastery.setSecondary(secondary);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CAPABILITY_ELEMENTAL_MASTERY) {
                return this.instance.cast();
            }
            return LazyOptional.empty();
        }
    }

    public static class Implementation
    extends ForgeRegistryEntry<Implementation>
    implements IElementalMastery {
        private Element primary = Element.NONE;
        private Element secondary = Element.NONE;

        public Implementation() {
        }

        public Implementation(Element primary) {
            this.primary = primary;
        }

        public Implementation(Element primary, Element secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public Element getPrimary() {
            return this.primary;
        }

        @Override
        public IElementalMastery setPrimary(Element primary) {
            if (this.primary != primary && primary != Element.NONE) {
                this.primary = primary;
            }
            return this;
        }

        @Override
        public Element getSecondary() {
            return this.secondary;
        }

        @Override
        public IElementalMastery setSecondary(Element secondary) {
            if (secondary != Element.NONE && this.primary != secondary) {
                this.secondary = secondary;
            }
            return this;
        }
    }

    public static interface IElementalMastery {
        public Element getPrimary();

        public IElementalMastery setPrimary(Element var1);

        public Element getSecondary();

        public IElementalMastery setSecondary(Element var1);
    }
}

