/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.data.recipe;

import com.sofodev.armorplus.data.recipe.Grid;
import com.sofodev.armorplus.data.recipe.Input;

public class GridInput {
    private final Grid grid;
    private final Input input;

    public GridInput(Grid grid, Input input) {
        this.grid = grid;
        this.input = input;
    }

    public static GridInput build(Grid grid, Input input) {
        return new GridInput(grid, input);
    }

    public static GridInput build(String rowA, Input input) {
        return new GridInput(Grid.build(rowA), input);
    }

    public static GridInput build(String rowA, String rowB, Input input) {
        return new GridInput(Grid.build(rowA, rowB), input);
    }

    public static GridInput build(String rowA, String rowB, String rowC, Input input) {
        return new GridInput(Grid.build(rowA, rowB, rowC), input);
    }

    public static GridInput build(String rowA, char ... chars) {
        if (rowA.length() != 3) {
            return new GridInput(Grid.buildFull(rowA), Input.build(chars));
        }
        return new GridInput(Grid.build(rowA), Input.build(chars));
    }

    public static GridInput build(String rowA, String rowB, char ... chars) {
        return new GridInput(Grid.build(rowA, rowB), Input.build(chars));
    }

    public static GridInput build(String rowA, String rowB, String rowC, char ... chars) {
        return new GridInput(Grid.build(rowA, rowB, rowC), Input.build(chars));
    }

    public static GridInput build(Grid grid, char ... chars) {
        return new GridInput(grid, Input.build(chars));
    }

    public static GridInput buildFull(String full, Input input) {
        return new GridInput(Grid.buildFull(full), input);
    }

    public static GridInput buildFull(String full, char ... chars) {
        return new GridInput(Grid.buildFull(full), Input.build(chars));
    }

    public Grid getGrid() {
        return this.grid;
    }

    public Input getSimpleInput() {
        return this.input;
    }

    public static GridInput buildSmallSquare(char filler) {
        String small = GridInput.replace("XX ", filler);
        return GridInput.build(Grid.build(small, small), filler);
    }

    public static GridInput buildBigSquare(char filler) {
        String big = GridInput.replace("XXX", filler);
        return GridInput.build(Grid.build(big, big, big), filler);
    }

    public static GridInput buildStairs(char filler) {
        String top = GridInput.replace("X  ", filler);
        String mid = GridInput.replace("XX ", filler);
        String bot = GridInput.replace("XXX", filler);
        return GridInput.build(Grid.build(top, mid, bot), filler);
    }

    public static GridInput buildSlab(char filler) {
        String big = GridInput.replace("XXX", filler);
        return GridInput.build(Grid.build(big), filler);
    }

    public static GridInput buildHollowSquare(char filler) {
        String hollow = GridInput.replace("X X", filler);
        String full = GridInput.replace("XXX", filler);
        return GridInput.build(Grid.build(full, hollow, full), filler);
    }

    public static GridInput buildHelmet(char filler) {
        String hollow = GridInput.replace("X X", filler);
        String full = GridInput.replace("XXX", filler);
        return GridInput.build(Grid.build(full, hollow), filler);
    }

    public static GridInput buildChestplate(char filler) {
        String hollow = GridInput.replace("X X", filler);
        String full = GridInput.replace("XXX", filler);
        return GridInput.build(Grid.build(hollow, full, full), filler);
    }

    public static GridInput buildLeggings(char filler) {
        String hollow = GridInput.replace("X X", filler);
        String full = GridInput.replace("XXX", filler);
        return GridInput.build(Grid.build(full, hollow, hollow), filler);
    }

    public static GridInput buildBoots(char filler) {
        String hollow = GridInput.replace("X X", filler);
        return GridInput.build(Grid.build(hollow, hollow), filler);
    }

    public static String replace(String txt, char replacement) {
        return txt.replace('X', replacement);
    }
}

