/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.events;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.events.data.FlightData;
import com.sofodev.armorplus.network.packet.PacketFlyingSync;
import com.sofodev.armorplus.registry.ModEnchantments;
import com.sofodev.armorplus.registry.ModItems;
import com.sofodev.armorplus.registry.ModVillagers;
import com.sofodev.armorplus.registry.items.armors.APArmorItem;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.extras.Buff;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import com.sofodev.armorplus.registry.items.extras.DeBuff;
import com.sofodev.armorplus.registry.items.materials.FrostCrystalItem;
import com.sofodev.armorplus.registry.items.tools.APMaceItem;
import com.sofodev.armorplus.registry.items.tools.properties.mace.APMaceType;
import com.sofodev.armorplus.registry.items.tools.properties.tool.IAPTool;
import com.sofodev.armorplus.registry.items.tools.properties.tool.Tool;
import com.sofodev.armorplus.utils.ItemArmorUtility;
import com.sofodev.armorplus.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TridentItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModGlobalEvents {
    public static final Random RAND = new Random();
    public static int waterTicks = 0;
    public static int thunderingTicks = 0;
    public static FlightData flightData = new FlightData(false, false, false);

    @SubscribeEvent
    public static void onArrowLooseEvent(ArrowLooseEvent e) {
        World world = e.getWorld();
        if (!world.func_201670_d()) {
            ItemStack bow = e.getBow();
            int charge = e.getCharge();
            ArmorPlus.LOGGER.info("Charge at: " + charge);
            boolean hasUnknownEnchant = false;
            Map enchantmentList = EnchantmentHelper.func_82781_a((ItemStack)bow);
            if (!enchantmentList.isEmpty() && (hasUnknownEnchant = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("unknown"))))) {
                Entity entity = e.getEntity();
                Direction direction = entity.func_174811_aO();
                BlockPos position = entity.func_233580_cy_();
                int distance = 5 + charge / (charge / 2);
                IntStream.range(distance, charge).forEach(i -> {
                    LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
                    if (lightningboltentity != null) {
                        switch (direction) {
                            case NORTH: {
                                lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177964_d(i)));
                                break;
                            }
                            case SOUTH: {
                                lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177970_e(i)));
                                break;
                            }
                            case WEST: {
                                lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177985_f(i)));
                                break;
                            }
                            case EAST: {
                                lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177965_g(i)));
                            }
                        }
                        world.func_217376_c((Entity)lightningboltentity);
                        bow.func_222118_a(10, (LivingEntity)entity, event -> event.func_213334_d(((LivingEntity)entity).func_184600_cs()));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent e) {
        PlayerEntity player = e.player;
        World world = player.field_70170_p;
        if (!world.func_201670_d()) {
            boolean thundering = world.func_72911_I();
            if (thundering) {
                int chance;
                boolean hasUnknownEnchant = false;
                if ((++thunderingTicks + 1) % 20 == 0 && (chance = RAND.nextInt(100) + 1) == 100) {
                    for (ItemStack item : player.func_184193_aE()) {
                        LightningBoltEntity lightningboltentity;
                        BlockPos blockpos;
                        Item itemHead = item.func_77973_b();
                        if (!(itemHead instanceof ArmorItem)) continue;
                        ArmorItem armorItem = (ArmorItem)itemHead;
                        IArmorMaterial material = armorItem.func_200880_d();
                        Map enchantmentList = EnchantmentHelper.func_82781_a((ItemStack)item);
                        if (enchantmentList.isEmpty() || !(hasUnknownEnchant = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("unknown")))) || armorItem.func_185083_B_() != EquipmentSlotType.HEAD || material != ArmorMaterial.IRON && material != ArmorMaterial.CHAIN && material != ArmorMaterial.GOLD || !world.func_226660_f_(blockpos = player.func_233580_cy_()) || (lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world)) == null) continue;
                        lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
                        lightningboltentity.func_204809_d((ServerPlayerEntity)player);
                        lightningboltentity.setDamage(0.0f);
                        world.func_217376_c((Entity)lightningboltentity);
                    }
                }
            }
            for (ItemStack stack : player.func_184193_aE()) {
                Item item = stack.func_77973_b();
                if (!(item instanceof APArmorItem)) {
                    return;
                }
                IAPArmor mat = ((APArmorItem)item).getMat();
                boolean areExactMatch = ItemArmorUtility.areExactMatch(mat, player);
                List buffList = mat.getBuffInstances().get().stream().map(BuffInstance::getBuff).collect(Collectors.toList());
                if (areExactMatch && mat.config().enableArmorEffects.get().booleanValue()) {
                    if (buffList.isEmpty()) continue;
                    if (buffList.contains(Buff.FLIGHT)) {
                        ModGlobalEvents.shouldApplyFlight(e, player);
                    }
                    if (!buffList.contains(Buff.WATER_WEAKNESS)) continue;
                    ModGlobalEvents.shouldApplyWaterWeakness(player);
                    continue;
                }
                ModGlobalEvents.attemptDisableFlight(e, player);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent e) {
        Random rand = new Random();
        VillagerProfession type = e.getType();
        if (type.equals(ModVillagers.SOUL_EXCHANGER.get())) {
            ItemStack witherSoul = new ItemStack((IItemProvider)ModItems.WITHER_BOSS_SOUL.get(), 1);
            ItemStack enderDragonSoul = new ItemStack((IItemProvider)ModItems.ENDER_DRAGON_SOUL.get(), 1);
            ItemStack elderGuardianSoul = new ItemStack((IItemProvider)ModItems.ELDER_GUARDIAN_SOUL.get(), 1);
            e.getTrades().put(1, Arrays.asList(new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3 + rand.nextInt(5)), new ItemStack((IItemProvider)ModItems.LAVA_SHARD.get(), 3 + rand.nextInt(3)), 16, 2, 0.4f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3 + rand.nextInt(5)), new ItemStack((IItemProvider)ModItems.FROST_SHARD.get(), 3 + rand.nextInt(3)), 16, 2, 0.4f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3 + rand.nextInt(5)), new ItemStack((IItemProvider)Items.field_151065_br, 3 + rand.nextInt(3)), 16, 2, 0.4f)));
            e.getTrades().put(2, Arrays.asList(new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 6 + rand.nextInt(4)), new ItemStack((IItemProvider)ModItems.LAVA_SHARD.get(), 5 + rand.nextInt(4)), 8, 6, 0.2f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 6 + rand.nextInt(4)), new ItemStack((IItemProvider)ModItems.FROST_SHARD.get(), 5 + rand.nextInt(4)), 8, 6, 0.2f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 6 + rand.nextInt(4)), new ItemStack((IItemProvider)Items.field_151072_bj, 2 + rand.nextInt(2)), 8, 6, 0.2f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 8 + rand.nextInt(6)), new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 1 + rand.nextInt(2)), 8, 10, 0.2f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 8 + rand.nextInt(6)), new ItemStack((IItemProvider)ModItems.FROST_CRYSTAL.get(), 1 + rand.nextInt(2)), 8, 10, 0.2f)));
            e.getTrades().put(3, Arrays.asList(new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 4 + rand.nextInt(20)), new ItemStack((IItemProvider)Items.field_221693_cI, 4 + rand.nextInt(16)), new ItemStack((IItemProvider)ModItems.WITHER_SKELETON_SOUL.get()), 6, 15, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 4 + rand.nextInt(20)), new ItemStack((IItemProvider)Items.field_221693_cI, 4 + rand.nextInt(16)), new ItemStack((IItemProvider)ModItems.SLAYER_SOUL.get()), 6, 15, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 4 + rand.nextInt(20)), new ItemStack((IItemProvider)Items.field_221879_fX, 4 + rand.nextInt(16)), new ItemStack((IItemProvider)ModItems.GUARDIAN_SOUL.get()), 6, 15, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 4 + rand.nextInt(20)), new ItemStack((IItemProvider)Items.field_221828_dx, 4 + rand.nextInt(16)), new ItemStack((IItemProvider)ModItems.ENDERMAN_SOUL.get()), 6, 15, 0.05f)));
            ItemStack priceBook = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData((Enchantment)ModEnchantments.SOUL_STEALER.get(), 1));
            e.getTrades().put(4, Arrays.asList(new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 6 + rand.nextInt(10)), witherSoul, elderGuardianSoul, 2, 20, 0.0f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 6 + rand.nextInt(10)), enderDragonSoul, elderGuardianSoul, 2, 20, 0.0f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 6 + rand.nextInt(10)), elderGuardianSoul, witherSoul, 2, 20, 0.0f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 6 + rand.nextInt(10)), enderDragonSoul, witherSoul, 2, 20, 0.0f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 6 + rand.nextInt(10)), witherSoul, enderDragonSoul, 2, 20, 0.0f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 6 + rand.nextInt(10)), elderGuardianSoul, enderDragonSoul, 2, 20, 0.0f), new BasicTrade(new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), 10 + rand.nextInt(10)), priceBook, 2, 20, 0.0f)));
            int bound = 5 + rand.nextInt(15);
            ItemStack priceILBA = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Utils.getAPItem("infused_lava_battle_axe")), (int)bound, (boolean)false);
            ItemStack priceILS = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Utils.getAPItem("infused_lava_sword")), (int)bound, (boolean)false);
            ItemStack priceDA = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Items.field_151056_x), (int)bound, (boolean)false);
            ItemStack priceDS = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Items.field_151048_u), (int)bound, (boolean)false);
            ItemStack priceNA = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Items.field_234757_kL_), (int)bound, (boolean)false);
            ItemStack priceNS = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Items.field_234754_kI_), (int)bound, (boolean)false);
            priceILBA.func_77966_a((Enchantment)ModEnchantments.SOUL_STEALER.get(), 1);
            priceILS.func_77966_a((Enchantment)ModEnchantments.SOUL_STEALER.get(), 1);
            priceDA.func_77966_a((Enchantment)ModEnchantments.SOUL_STEALER.get(), 1);
            priceDS.func_77966_a((Enchantment)ModEnchantments.SOUL_STEALER.get(), 1);
            priceNA.func_77966_a((Enchantment)ModEnchantments.SOUL_STEALER.get(), 1);
            priceNS.func_77966_a((Enchantment)ModEnchantments.SOUL_STEALER.get(), 1);
            int crystalAmount = Math.min(10 + bound, 64);
            ItemStack crystalCost = new ItemStack((IItemProvider)ModItems.LAVA_CRYSTAL.get(), crystalAmount);
            e.getTrades().put(5, Arrays.asList(new BasicTrade(witherSoul, elderGuardianSoul, 3, 25, 0.0f), new BasicTrade(enderDragonSoul, elderGuardianSoul, 3, 25, 0.0f), new BasicTrade(elderGuardianSoul, witherSoul, 3, 25, 0.0f), new BasicTrade(enderDragonSoul, witherSoul, 3, 25, 0.0f), new BasicTrade(witherSoul, enderDragonSoul, 3, 25, 0.0f), new BasicTrade(elderGuardianSoul, enderDragonSoul, 3, 25, 0.0f), new BasicTrade(crystalCost, priceILBA, 1, 30, 0.0f), new BasicTrade(crystalCost, priceILS, 1, 30, 0.0f), new BasicTrade(crystalCost, priceDA, 1, 30, 0.0f), new BasicTrade(crystalCost, priceDS, 1, 30, 0.0f), new BasicTrade(crystalCost, priceNA, 1, 30, 0.0f), new BasicTrade(crystalCost, priceNS, 1, 30, 0.0f)));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorldEvent(EntityJoinWorldEvent e) {
        boolean isRunning = false;
    }

    private static void shouldApplyFlight(TickEvent.PlayerTickEvent e, PlayerEntity player) {
        if (e.phase == TickEvent.Phase.END && e.side.isServer() && (!player.field_71075_bZ.field_75101_c || Utils.allowsFlightByDefault(player))) {
            player.field_71075_bZ.field_75101_c = true;
            ModGlobalEvents.updateClientServerFlight(player, true);
        }
    }

    private static void attemptDisableFlight(TickEvent.PlayerTickEvent e, PlayerEntity player) {
        if (e.phase == TickEvent.Phase.END && e.side.isServer()) {
            player.func_184193_aE().forEach(i -> {
                if (!i.func_190926_b() || flightData.allowFlying() && flightData.wasFlyingAllowed()) {
                    if (player.field_71075_bZ.field_75101_c && flightData.allowFlying() && flightData.wasFlyingAllowed() && !Utils.allowsFlightByDefault(player)) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        ModGlobalEvents.updateClientServerFlight(player, false);
                        flightData.setFlying(false);
                        flightData.setAllowFlying(false);
                    } else if (i.func_77973_b() instanceof APArmorItem && ItemArmorUtility.areExactMatch(((APArmorItem)i.func_77973_b()).getMat(), player) && player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        ModGlobalEvents.updateClientServerFlight(player, false);
                        flightData.setFlying(false);
                        flightData.setAllowFlying(false);
                    }
                }
            });
        }
    }

    private static void updateClientServerFlight(PlayerEntity player, boolean allowFlying) {
        ModGlobalEvents.updateClientServerFlight(player, allowFlying, allowFlying && player.field_71075_bZ.field_75100_b);
    }

    private static void updateClientServerFlight(PlayerEntity player, boolean allowFlying, boolean isFlying) {
        ArmorPlus.PACKET_HANDLER.sendTo(new PacketFlyingSync(allowFlying, isFlying), (ServerPlayerEntity)player);
        player.field_71075_bZ.field_75101_c = allowFlying;
        player.field_71075_bZ.field_75100_b = isFlying;
        ModGlobalEvents.updateFlightData(player);
    }

    private static void updateFlightData(PlayerEntity player) {
        flightData.setFlying(player.field_71075_bZ.field_75100_b);
        flightData.setAllowFlying(player.field_71075_bZ.field_75101_c);
        flightData.setWasFlyingAllowed(player.field_71075_bZ.field_75101_c);
    }

    private static void shouldApplyWaterWeakness(PlayerEntity player) {
        if (player.func_70090_H() && (++waterTicks + 1) % 20 == 0) {
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_190926_b() || stack.getEquipmentSlot() == null) continue;
                stack.func_222118_a(1, (LivingEntity)player, event -> event.func_213361_c(stack.getEquipmentSlot()));
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        Map enchantmentList;
        World world = event.getEntityLiving().field_70170_p;
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        float attackDamage = (float)player.func_233637_b_(Attributes.field_233823_f_);
        double movedDistance = player.field_70140_Q - player.field_70141_P;
        boolean isMace = false;
        ItemStack stack = player.func_184614_ca();
        boolean hasUnknown = false;
        if (!world.func_201670_d() && !stack.func_190926_b() && stack.func_77973_b() instanceof TridentItem && !(enchantmentList = EnchantmentHelper.func_82781_a((ItemStack)stack)).isEmpty() && (hasUnknown = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("unknown"))))) {
            BlockPos position = target.func_233580_cy_();
            LightningBoltEntity northBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            LightningBoltEntity southBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            LightningBoltEntity westBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            LightningBoltEntity eastBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            LightningBoltEntity centreBolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            if (northBolt != null && southBolt != null && westBolt != null && eastBolt != null && centreBolt != null) {
                northBolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177964_d(1)));
                southBolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177970_e(1)));
                westBolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177985_f(1)));
                eastBolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position.func_177965_g(1)));
                centreBolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)position));
                world.func_217376_c((Entity)northBolt);
                world.func_217376_c((Entity)southBolt);
                world.func_217376_c((Entity)westBolt);
                world.func_217376_c((Entity)eastBolt);
                world.func_217376_c((Entity)centreBolt);
            }
            player.func_195064_c(new EffectInstance(DeBuff.SLOWNESS.getEffect(), Utils.convertToSeconds(4)));
            player.func_195064_c(new EffectInstance(DeBuff.MINING_FATIGUE.getEffect(), Utils.convertToSeconds(4)));
        }
        if (player.func_233570_aj_() && movedDistance < (double)player.func_70689_ay() && stack.func_77973_b() instanceof APMaceItem) {
            isMace = true;
        }
        if (isMace) {
            APMaceItem mace = (APMaceItem)stack.func_77973_b();
            float sweepingDamage = 1.0f + APMaceType.getMaceSweepingRatio(mace.mat.getType()) * attackDamage;
            for (LivingEntity entity : world.func_217357_a(LivingEntity.class, target.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                boolean isReachable;
                boolean isNewTarget = entity != player && entity != target;
                boolean isValidTarget = !player.func_184191_r((Entity)entity) && (!(entity instanceof ArmorStandEntity) || !((ArmorStandEntity)entity).func_181026_s());
                boolean bl = isReachable = player.func_70068_e((Entity)entity) < 15.0;
                if (!isNewTarget || !isValidTarget || !isReachable) continue;
                double ratioX = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
                double ratioZ = -MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
                entity.func_233627_a_(0.4f, ratioX, ratioZ);
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), sweepingDamage);
            }
            if (world.field_72995_K) {
                mace.swingAnimation(GeckoLibUtil.getControllerForStack((AnimationFactory)mace.factory, (ItemStack)stack, (String)mace.controllerName));
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
            player.func_184810_cG();
        }
    }

    @SubscribeEvent
    public static void onStructByLightningEvent(EntityStruckByLightningEvent event) {
        boolean infused;
        ItemEntity entity;
        Item item;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof ItemEntity && (item = (entity = (ItemEntity)event.getEntity()).func_92059_d().func_77973_b()) instanceof FrostCrystalItem && !(infused = ((FrostCrystalItem)item).isInfused())) {
            FrostCrystalItem infusedCrystal = (FrostCrystalItem)Utils.getAPItem("infused_frost_crystal");
            entity.func_70099_a(new ItemStack((IItemProvider)infusedCrystal, entity.func_92059_d().func_190916_E()), 1.0f);
            entity.func_92059_d().func_190920_e(0);
            event.getLightning().func_233623_a_(true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            IAPTool mat;
            List buffList;
            ItemStack stack;
            Item item;
            PlayerEntity player = (PlayerEntity)entity;
            if (!player.field_70170_p.func_201670_d() && (item = (stack = player.func_184614_ca()).func_77973_b()) instanceof Tool && !(buffList = (mat = ((Tool)item).getMat()).getBuffInstances().get().stream().map(BuffInstance::getBuff).collect(Collectors.toList())).isEmpty() && buffList.contains(DeBuff.IGNITE)) {
                DeBuff.IGNITE.hitEntity(stack, entity, (LivingEntity)player);
            }
        }
        ArrayList<ItemStack> armor = new ArrayList<ItemStack>();
        for (ItemStack slotStack : entity.func_184193_aE()) {
            armor.add(slotStack);
        }
        if (!armor.isEmpty()) {
            for (ItemStack stack : armor) {
                boolean hasSoulHarden;
                if (!stack.func_77984_f() || !(stack.func_77973_b() instanceof ArmorItem)) continue;
                ArmorItem item = (ArmorItem)stack.func_77973_b();
                Map enchantmentList = EnchantmentHelper.func_82781_a((ItemStack)stack);
                if (enchantmentList.isEmpty() || !(hasSoulHarden = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_harden"))))) continue;
                int maxDamageValue = stack.func_77958_k();
                int currentDamageValue = maxDamageValue - stack.func_77952_i();
                int halfDamageValue = Math.min(maxDamageValue / 2, Math.floorDiv(maxDamageValue, 2));
                if (currentDamageValue == maxDamageValue) {
                    stack.func_196085_b(0);
                    continue;
                }
                stack.func_196085_b(stack.func_77952_i() - 1);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ArrayList<ItemStack> armor = new ArrayList<ItemStack>();
        for (ItemStack slotStack : entity.func_184193_aE()) {
            armor.add(slotStack);
        }
        if (!armor.isEmpty()) {
            for (ItemStack stack : armor) {
                boolean hasSoulHarden;
                if (!stack.func_77984_f() || !(stack.func_77973_b() instanceof ArmorItem)) continue;
                ArmorItem item = (ArmorItem)stack.func_77973_b();
                Map enchantmentList = EnchantmentHelper.func_82781_a((ItemStack)stack);
                if (enchantmentList.isEmpty() || !(hasSoulHarden = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_harden"))))) continue;
                int maxDamageValue = stack.func_77958_k();
                int incomingDamageValue = stack.func_77952_i();
                int currentDamageValue = maxDamageValue - incomingDamageValue;
                int halfDamageValue = Math.min(maxDamageValue / 2, Math.floorDiv(maxDamageValue, 2));
                if (currentDamageValue == maxDamageValue) {
                    stack.func_196085_b(halfDamageValue);
                    continue;
                }
                if (incomingDamageValue >= halfDamageValue) {
                    stack.func_196085_b(halfDamageValue);
                    continue;
                }
                stack.func_196085_b(maxDamageValue);
                stack.func_190920_e(0);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDropEvent(LivingDropsEvent event) {
        ServerPlayerEntity player;
        ItemStack heldItem;
        boolean oneInFourChance = RAND.nextInt(4) == 0;
        int amountZeroToTwo = RAND.nextInt(3);
        int amountFourToSix = RAND.nextInt(3) + 4;
        LivingEntity entity = event.getEntityLiving();
        Entity trueSource = event.getSource().func_76346_g();
        boolean isSourcePlayer = trueSource instanceof ServerPlayerEntity;
        boolean hasSoulStealer = false;
        if (isSourcePlayer && !(heldItem = (player = (ServerPlayerEntity)trueSource).func_184614_ca()).func_190926_b()) {
            Map enchantmentList = EnchantmentHelper.func_82781_a((ItemStack)heldItem);
            hasSoulStealer = enchantmentList.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("soul_stealer")));
        }
        if (entity != null) {
            if (entity instanceof WitherEntity) {
                if (ArmorPlusConfig.witherBossDrops.enableTrophyDrops.get().booleanValue()) {
                    ModGlobalEvents.dropTrophyItem(entity, EntityType.field_200760_az, 0.2f);
                }
                if (ArmorPlusConfig.witherBossDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "wither_bone", amountFourToSix);
                }
                if (hasSoulStealer && ArmorPlusConfig.witherBossDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_wither_boss", 1);
                }
            } else if (entity instanceof EnderDragonEntity) {
                if (ArmorPlusConfig.enderDragonDrops.enableTrophyDrops.get().booleanValue()) {
                    ModGlobalEvents.dropTrophyItem(entity, EntityType.field_200802_p, 0.1f);
                }
                if (ArmorPlusConfig.enderDragonDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "ender_dragon_scale", amountFourToSix);
                }
                if (hasSoulStealer && ArmorPlusConfig.enderDragonDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_ender_dragon", 1);
                }
            } else if (entity instanceof ElderGuardianEntity) {
                if (ArmorPlusConfig.elderGuardianDrops.enableTrophyDrops.get().booleanValue()) {
                    ModGlobalEvents.dropTrophyItem(entity, EntityType.field_200800_n, 0.2f);
                }
                if (ArmorPlusConfig.elderGuardianDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "guardian_scale", amountFourToSix);
                }
                if (hasSoulStealer && ArmorPlusConfig.elderGuardianDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_elder_guardian", 1);
                }
            } else if (entity instanceof WitherSkeletonEntity) {
                if (ArmorPlusConfig.witherSkeletonDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "wither_bone", amountZeroToTwo);
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.witherSkeletonDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_wither_skeleton", 1);
                }
            } else if (entity instanceof GuardianEntity) {
                if (ArmorPlusConfig.guardianDrops.enableRegularDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "guardian_scale", amountZeroToTwo);
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.guardianDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_guardian", 1);
                }
            } else if (entity instanceof EndermanEntity) {
                if (ArmorPlusConfig.endermanDrops.enableRegularDrops.get().booleanValue()) {
                    // empty if block
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.endermanDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_enderman", 1);
                }
            } else if (entity instanceof BlazeEntity) {
                if (ArmorPlusConfig.blazeDrops.enableRegularDrops.get().booleanValue()) {
                    // empty if block
                }
                if (hasSoulStealer && oneInFourChance && ArmorPlusConfig.blazeDrops.enableSoulDrops.get().booleanValue()) {
                    ModGlobalEvents.dropItem((Entity)entity, "soul_blaze", 1);
                }
            }
        }
    }

    private static void dropTrophyItem(LivingEntity entity, EntityType<?> type, float scale) {
        ItemStack trophy = new ItemStack((IItemProvider)Utils.getAPItem("trophy"));
        CompoundNBT tag = new CompoundNBT();
        WeightedSpawnerEntity trophyEntity = new WeightedSpawnerEntity();
        trophyEntity.func_185277_b().func_74778_a("id", ForgeRegistries.ENTITIES.getKey(type).toString());
        tag.func_218657_a("DisplayEntity", (INBT)trophyEntity.func_185277_b().func_74737_b());
        tag.func_74776_a("EntityScale", scale);
        trophy.func_77982_d(tag);
        entity.func_199701_a_(trophy);
    }

    private static void dropItem(Entity entity, String item, int amount) {
        entity.func_199701_a_(new ItemStack((IItemProvider)Utils.getAPItem(item), amount));
    }
}

