/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.events;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.ModConfiguredFeatures;
import java.util.Arrays;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="armorplus")
public class WorldGenEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        boolean isFreezing;
        boolean isSnowy = WorldGenEvents.matchesBiomes(event.getCategory(), Biome.Category.ICY, Biome.Category.TAIGA, Biome.Category.EXTREME_HILLS);
        boolean isSnowing = event.getClimate().field_242460_b == Biome.RainType.SNOW;
        boolean bl = isFreezing = event.getClimate().field_242462_d == Biome.TemperatureModifier.FROZEN;
        if (!WorldGenEvents.matchesBiomes(event.getCategory(), Biome.Category.ICY, Biome.Category.THEEND, Biome.Category.OCEAN, Biome.Category.NONE)) {
            WorldGenEvents.withConfiguration(event, ModConfiguredFeatures.CF_ORE_LAVA_CR_STONE, ArmorPlusConfig.oreLavaCrystalStone.enabled.get());
            WorldGenEvents.withConfiguration(event, ModConfiguredFeatures.CF_ORE_LAVA_CR_OBSIDIAN, ArmorPlusConfig.oreLavaCrystalObsidian.enabled.get());
            WorldGenEvents.withConfiguration(event, ModConfiguredFeatures.CF_ORE_LAVA_CRYSTAL, ArmorPlusConfig.oreLavaCrystalCompressed.enabled.get());
        }
        if (isSnowy || isSnowing || isFreezing) {
            WorldGenEvents.withConfiguration(event, ModConfiguredFeatures.CF_ORE_FROST_CR_STONE, ArmorPlusConfig.oreFrostCrystalStone.enabled.get());
            WorldGenEvents.withConfiguration(event, ModConfiguredFeatures.CF_ORE_FROST_CR_OBSIDIAN, ArmorPlusConfig.oreFrostCrystalObsidian.enabled.get());
            WorldGenEvents.withConfiguration(event, ModConfiguredFeatures.CF_ORE_FROST_CRYSTAL, ArmorPlusConfig.oreFrostCrystalCompressed.enabled.get());
        }
    }

    private static void withConfiguration(BiomeLoadingEvent event, ConfiguredFeature<?, ?> configuredFeature, boolean enabled) {
        if (enabled) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> configuredFeature);
        }
    }

    private static boolean matchesBiomes(Biome.Category category, Biome.Category ... categories) {
        return Arrays.stream(categories).anyMatch(s -> category.func_222352_a().equals(s.func_222352_a()));
    }
}

