/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.registry.entities.arrows.APArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.ArrowType;
import com.sofodev.armorplus.registry.entities.arrows.impl.CoalArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.EmeraldArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.EnderDragonArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.GuardianArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.InfusedLavaArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.LapisArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.ObsidianArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.RedstoneArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.SuperStarArrowEntity;
import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.SkeletalKingEntity;
import com.sofodev.armorplus.registry.entities.bosses.data.MobType;
import com.sofodev.armorplus.registry.entities.normal.BoreasEntity;
import com.sofodev.armorplus.registry.entities.normal.FrostWolfAlphaEntity;
import com.sofodev.armorplus.registry.entities.normal.FrostWolfEntity;
import com.sofodev.armorplus.registry.entities.normal.WitherlingEntity;
import com.sofodev.armorplus.utils.Utils;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"armorplus");
    public static final RegistryObject<EntityType<APArrowEntity>> COAL_ARROW = ModEntities.register("coal_arrow", () -> ModEntities.buildArrow(CoalArrowEntity::new, ArrowType.COAL));
    public static final RegistryObject<EntityType<APArrowEntity>> LAPIS_ARROW = ModEntities.register("lapis_arrow", () -> ModEntities.buildArrow(LapisArrowEntity::new, ArrowType.LAPIS));
    public static final RegistryObject<EntityType<APArrowEntity>> REDSTONE_ARROW = ModEntities.register("redstone_arrow", () -> ModEntities.buildArrow(RedstoneArrowEntity::new, ArrowType.REDSTONE));
    public static final RegistryObject<EntityType<APArrowEntity>> EMERALD_ARROW = ModEntities.register("emerald_arrow", () -> ModEntities.buildArrow(EmeraldArrowEntity::new, ArrowType.EMERALD));
    public static final RegistryObject<EntityType<APArrowEntity>> OBSIDIAN_ARROW = ModEntities.register("obsidian_arrow", () -> ModEntities.buildArrow(ObsidianArrowEntity::new, ArrowType.OBSIDIAN));
    public static final RegistryObject<EntityType<APArrowEntity>> INFUSED_LAVA_ARROW = ModEntities.register("infused_lava_arrow", () -> ModEntities.buildArrow(InfusedLavaArrowEntity::new, ArrowType.INFUSED_LAVA));
    public static final RegistryObject<EntityType<APArrowEntity>> GUARDIAN_ARROW = ModEntities.register("guardian_arrow", () -> ModEntities.buildArrow(GuardianArrowEntity::new, ArrowType.GUARDIAN));
    public static final RegistryObject<EntityType<APArrowEntity>> SUPER_STAR_ARROW = ModEntities.register("super_star_arrow", () -> ModEntities.buildArrow(SuperStarArrowEntity::new, ArrowType.SUPER_STAR));
    public static final RegistryObject<EntityType<APArrowEntity>> ENDER_DRAGON_ARROW = ModEntities.register("ender_dragon_arrow", () -> ModEntities.buildArrow(EnderDragonArrowEntity::new, ArrowType.ENDER_DRAGON));
    public static final RegistryObject<EntityType<SkeletalKingEntity>> SKELETAL_KING = ModEntities.register("skeletal_king", () -> ModEntities.build(SkeletalKingEntity::new, MobType.SKELETAL_KING));
    public static final RegistryObject<EntityType<WitherlingEntity>> WITHERLING = ModEntities.register("witherling", () -> ModEntities.build(WitherlingEntity::new, MobType.WITHERLING));
    public static final RegistryObject<EntityType<DemonicDragonEntity>> DEMONIC_DRAGON = ModEntities.register("demonic_dragon", () -> ModEntities.build(DemonicDragonEntity::new, MobType.DEMONIC_DRAGON));
    public static final RegistryObject<EntityType<FrostWolfEntity>> FROST_WOLF = ModEntities.register("frost_wolf", () -> ModEntities.build(FrostWolfEntity::new, MobType.FROST_WOLF));
    public static final RegistryObject<EntityType<FrostWolfAlphaEntity>> FROST_WOLF_ALPHA = ModEntities.register("frost_wolf_alpha", () -> ModEntities.build(FrostWolfAlphaEntity::new, MobType.FROST_WOLF_ALPHA));
    public static final RegistryObject<EntityType<BoreasEntity>> BOREAS = ModEntities.register("boreas", () -> ModEntities.build(BoreasEntity::new, MobType.BOREAS));

    public static <T extends Entity> RegistryObject<EntityType<T>> register(String name, Supplier<EntityType<T>> sup) {
        return ENTITY_TYPES.register(name, sup);
    }

    private static <T extends AbstractArrowEntity> EntityType<T> buildArrow(EntityType.IFactory<T> factoryIn, ArrowType data) {
        return ModEntities.build(data.getItemArrowName(), EntityType.Builder.func_220322_a(factoryIn, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f));
    }

    private static <T extends Entity> EntityType<T> build(EntityType.IFactory<T> factory, MobType data) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)data.getClassification()).setTrackingRange(data.getTrackingRange()).func_220321_a(data.getWidth(), data.getHeight());
        if (data.isImmuneToFire()) {
            builder.func_220320_c();
        }
        return ModEntities.build(data.getName(), builder);
    }

    private static <T extends Entity> EntityType<T> build(String id, EntityType.Builder<T> builder) {
        ResourceLocation rl = Utils.setRL(id);
        return builder.func_206830_a(rl.toString());
    }
}

