/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.mojang.serialization.Codec;
import com.sofodev.armorplus.registry.features.APOreFeature;
import com.sofodev.armorplus.registry.features.APOreFeatureConfig;
import com.sofodev.armorplus.registry.features.surface.BlackstoneValleySurfaceBuilder;
import com.sofodev.armorplus.registry.features.surface.SoulValleySurfaceBuilder;
import java.util.function.Supplier;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="armorplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    public static final DeferredRegister<SurfaceBuilder<?>> SURFACE_BUILDERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SURFACE_BUILDERS, (String)"armorplus");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"armorplus");
    public static final RegistryObject<SurfaceBuilder<SurfaceBuilderConfig>> SOUL_VALLEY = ModFeatures.createSurfaceBuilder("soul_valley", () -> new SoulValleySurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_));
    public static final RegistryObject<SurfaceBuilder<SurfaceBuilderConfig>> POSSESSED_GROUNDS = ModFeatures.createSurfaceBuilder("possessed_grounds", () -> new BlackstoneValleySurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_));
    public static final RegistryObject<Feature<APOreFeatureConfig>> ORE_CONFIG = ModFeatures.createFeature("ap_ore_feature", () -> new APOreFeature(APOreFeatureConfig.CODEC));

    public static <F extends Feature<?>> RegistryObject<F> createFeature(String name, Supplier<F> feature) {
        return FEATURES.register(name, feature);
    }

    public static <F extends SurfaceBuilder<?>> RegistryObject<F> createSurfaceBuilder(String name, Supplier<F> feature) {
        return SURFACE_BUILDERS.register(name, feature);
    }
}

