/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.entities.arrows.ArrowType;
import com.sofodev.armorplus.registry.items.APItemBase;
import com.sofodev.armorplus.registry.items.armors.APArmorItem;
import com.sofodev.armorplus.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.arrows.APArrowItem;
import com.sofodev.armorplus.registry.items.materials.FrostCrystalItem;
import com.sofodev.armorplus.registry.items.materials.FrostLavaCrystalItem;
import com.sofodev.armorplus.registry.items.materials.LavaCrystalItem;
import com.sofodev.armorplus.registry.items.materials.MaterialItem;
import com.sofodev.armorplus.registry.items.special.SoulItem;
import com.sofodev.armorplus.registry.items.special.ThankYouItem;
import com.sofodev.armorplus.registry.items.tools.APBattleAxeItem;
import com.sofodev.armorplus.registry.items.tools.APBowItem;
import com.sofodev.armorplus.registry.items.tools.APMaceItem;
import com.sofodev.armorplus.registry.items.tools.APPickaxeItem;
import com.sofodev.armorplus.registry.items.tools.APSwordItem;
import com.sofodev.armorplus.registry.items.tools.properties.mace.APMaceMaterial;
import com.sofodev.armorplus.registry.items.tools.properties.tool.APToolMaterial;
import com.sofodev.armorplus.registry.items.tools.render.APMaceRenderer;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="armorplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"armorplus");
    public static final Set<RegistryObject<APArmorItem>> HELMETS = ModItems.registerArmorForSlot(EquipmentSlotType.HEAD);
    public static final Set<RegistryObject<APArmorItem>> CHESTPLATES = ModItems.registerArmorForSlot(EquipmentSlotType.CHEST);
    public static final Set<RegistryObject<APArmorItem>> LEGGINGS = ModItems.registerArmorForSlot(EquipmentSlotType.LEGS);
    public static final Set<RegistryObject<APArmorItem>> BOOTS = ModItems.registerArmorForSlot(EquipmentSlotType.FEET);
    public static final Set<RegistryObject<Item>> SUPER_STAR_BASES = ModItems.registerArmorBases(APArmorMaterial.SUPER_STAR);
    public static final Set<RegistryObject<Item>> GUARDIAN_BASES = ModItems.registerArmorBases(APArmorMaterial.GUARDIAN);
    public static final Set<RegistryObject<Item>> ENDER_DRAGON_BASES = ModItems.registerArmorBases(APArmorMaterial.ENDER_DRAGON);
    public static final Set<RegistryObject<Item>> SLAYER_BASES = ModItems.registerArmorBases(APArmorMaterial.SLAYER);
    public static final RegistryObject<Item> GUARDIAN_SWORD_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "sword");
    public static final RegistryObject<Item> GUARDIAN_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "battle_axe");
    public static final RegistryObject<Item> GUARDIAN_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "pickaxe");
    public static final RegistryObject<Item> GUARDIAN_BOW_BASE = ModItems.registerBase(APToolMaterial.GUARDIAN_MAT, "bow");
    public static final RegistryObject<Item> SUPER_STAR_SWORD_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "sword");
    public static final RegistryObject<Item> SUPER_STAR_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "battle_axe");
    public static final RegistryObject<Item> SUPER_STAR_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "pickaxe");
    public static final RegistryObject<Item> SUPER_STAR_BOW_BASE = ModItems.registerBase(APToolMaterial.SUPER_STAR_MAT, "bow");
    public static final RegistryObject<Item> ENDER_DRAGON_SWORD_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "sword");
    public static final RegistryObject<Item> ENDER_DRAGON_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "battle_axe");
    public static final RegistryObject<Item> ENDER_DRAGON_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "pickaxe");
    public static final RegistryObject<Item> ENDER_DRAGON_BOW_BASE = ModItems.registerBase(APToolMaterial.ENDER_DRAGON_MAT, "bow");
    public static final RegistryObject<Item> SLAYER_SWORD_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "sword");
    public static final RegistryObject<Item> SLAYER_BATTLE_AXE_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "battle_axe");
    public static final RegistryObject<Item> SLAYER_PICKAXE_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "pickaxe");
    public static final RegistryObject<Item> SLAYER_BOW_BASE = ModItems.registerBase(APToolMaterial.SLAYER_MAT, "bow");
    public static final RegistryObject<Item>[] SWORDS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] BATTLE_AXES = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] PICKAXES = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] SHOVELS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] BOWS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] MACES = new RegistryObject[ArmorPlus.AP_MACE_MAT_LENGTH];
    public static final RegistryObject<ArrowItem> ITEM_COAL_ARROW = ModItems.registerArrow(ArrowType.COAL);
    public static final RegistryObject<ArrowItem> ITEM_LAPIS_ARROW = ModItems.registerArrow(ArrowType.LAPIS);
    public static final RegistryObject<ArrowItem> ITEM_REDSTONE_ARROW = ModItems.registerArrow(ArrowType.REDSTONE);
    public static final RegistryObject<ArrowItem> ITEM_EMERALD_ARROW = ModItems.registerArrow(ArrowType.EMERALD);
    public static final RegistryObject<ArrowItem> ITEM_OBSIDIAN_ARROW = ModItems.registerArrow(ArrowType.OBSIDIAN);
    public static final RegistryObject<ArrowItem> ITEM_INFUSED_LAVA_ARROW = ModItems.registerArrow(ArrowType.INFUSED_LAVA);
    public static final RegistryObject<ArrowItem> ITEM_GUARDIAN_ARROW = ModItems.registerArrow(ArrowType.GUARDIAN);
    public static final RegistryObject<ArrowItem> ITEM_SUPER_STAR_ARROW = ModItems.registerArrow(ArrowType.SUPER_STAR);
    public static final RegistryObject<ArrowItem> ITEM_ENDER_DRAGON_ARROW = ModItems.registerArrow(ArrowType.ENDER_DRAGON);
    public static final Set<RegistryObject<BlockItem>> ITEM_BLOCKS = ModItems.registerBlockItems();
    public static final RegistryObject<Item> LAVA_CRYSTAL = ITEMS.register("lava_crystal", () -> new LavaCrystalItem(false));
    public static final RegistryObject<Item> INFUSED_LAVA_CRYSTAL = ITEMS.register("infused_lava_crystal", () -> new LavaCrystalItem(true));
    public static final RegistryObject<Item> FROST_CRYSTAL = ITEMS.register("frost_crystal", () -> new FrostCrystalItem(false));
    public static final RegistryObject<Item> INFUSED_FROST_CRYSTAL = ITEMS.register("infused_frost_crystal", () -> new FrostCrystalItem(true));
    public static final RegistryObject<Item> INFUSED_FROST_LAVA_CRYSTAL = ITEMS.register("infused_frost_lava_crystal", FrostLavaCrystalItem::new);
    public static final RegistryObject<Item> CHAINMAIL = ITEMS.register("chainmail", () -> new MaterialItem(TextFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> GUARDIAN_SCALE = ITEMS.register("guardian_scale", () -> new MaterialItem(TextFormatting.BLUE, new Item.Properties()));
    public static final RegistryObject<Item> WITHER_BONE = ITEMS.register("wither_bone", () -> new MaterialItem(TextFormatting.WHITE, new Item.Properties().func_234689_a_()));
    public static final RegistryObject<Item> ENDER_DRAGON_SCALE = ITEMS.register("ender_dragon_scale", () -> new MaterialItem(TextFormatting.DARK_PURPLE, new Item.Properties()));
    public static final RegistryObject<Item> THE_ULTIMATE_MATERIAL = ITEMS.register("the_ultimate_material", () -> new MaterialItem(TextFormatting.DARK_PURPLE, new Item.Properties().func_234689_a_()));
    public static final RegistryObject<Item> WITHER_BOSS_SOUL = ITEMS.register("soul_wither_boss", () -> new SoulItem("wither"));
    public static final RegistryObject<Item> ELDER_GUARDIAN_SOUL = ITEMS.register("soul_elder_guardian", () -> new SoulItem("elder_guardian"));
    public static final RegistryObject<Item> ENDER_DRAGON_SOUL = ITEMS.register("soul_ender_dragon", () -> new SoulItem("ender_dragon"));
    public static final RegistryObject<Item> WITHER_SKELETON_SOUL = ITEMS.register("soul_wither_skeleton", () -> new SoulItem(false, "wither_skeleton"));
    public static final RegistryObject<Item> GUARDIAN_SOUL = ITEMS.register("soul_guardian", () -> new SoulItem(false, "guardian"));
    public static final RegistryObject<Item> ENDERMAN_SOUL = ITEMS.register("soul_enderman", () -> new SoulItem(false, "enderman"));
    public static final RegistryObject<Item> BLAZE_SOUL = ITEMS.register("soul_blaze", () -> new SoulItem(false, "blaze"));
    public static final RegistryObject<Item> SLAYER_SOUL = ITEMS.register("soul_slayer", () -> new SoulItem(null));
    public static final RegistryObject<Item> ENHANCED_CHAINMAIL = ITEMS.register("en_chainmail", () -> new MaterialItem(true, TextFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_IRON = ITEMS.register("en_iron", () -> new MaterialItem(true, TextFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_GOLD = ITEMS.register("en_gold", () -> new MaterialItem(true, TextFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_DIAMOND = ITEMS.register("en_diamond", () -> new MaterialItem(true, TextFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> ENHANCED_NETHERITE = ITEMS.register("en_netherite", () -> new MaterialItem(true, TextFormatting.GRAY, new Item.Properties().func_234689_a_()));
    public static final RegistryObject<Item> OBSIDIAN_STICK = ITEMS.register("obsidian_stick", () -> new MaterialItem(false, TextFormatting.DARK_PURPLE, new Item.Properties().func_234689_a_()));
    public static final RegistryObject<Item> WOODEN_ROD = ITEMS.register("wooden_rod", () -> new MaterialItem(false, TextFormatting.GRAY, new Item.Properties()));
    public static final RegistryObject<Item> LAVA_SHARD = ITEMS.register("lava_shard", () -> new MaterialItem(false, TextFormatting.GOLD, new Item.Properties()));
    public static final RegistryObject<Item> FROST_SHARD = ITEMS.register("frost_shard", () -> new MaterialItem(false, TextFormatting.AQUA, new Item.Properties()));
    public static final RegistryObject<Item> THANK_YOU_6M = ITEMS.register("thank_you_6m", ThankYouItem::new);

    public static Set<RegistryObject<APArmorItem>> registerArmorForSlot(EquipmentSlotType slot) {
        return Arrays.stream(APArmorMaterial.values()).map(mat -> ITEMS.register(String.format("%s_%s", mat.getName(), Utils.getNormalizedName(slot)), () -> new APArmorItem((IAPArmor)mat, slot))).collect(Collectors.toSet());
    }

    public static void registerToolForType(RegistryObject<Item>[] swords, RegistryObject<Item>[] axes, RegistryObject<Item>[] pickaxes, RegistryObject<Item>[] bows) {
        IntStream.range(0, ArmorPlus.AP_TOOL_MATERIAL_LENGTH).forEach(i -> {
            APToolMaterial mat = APToolMaterial.values()[i];
            swords[i] = ITEMS.register(String.format("%s_sword", mat.getName()), () -> new APSwordItem(mat));
            axes[i] = ITEMS.register(String.format("%s_battle_axe", mat.getName()), () -> new APBattleAxeItem(mat));
            pickaxes[i] = ITEMS.register(String.format("%s_pickaxe", mat.getName()), () -> new APPickaxeItem(mat));
            bows[i] = ITEMS.register(String.format("%s_bow", mat.getName()), () -> new APBowItem(mat));
        });
    }

    public static RegistryObject<Item> registerBase(APToolMaterial mat, String type) {
        return ITEMS.register(String.format("%s_%s_base", mat.getName(), type), APItemBase::new);
    }

    public static void registerMaceForType(RegistryObject<Item>[] maces) {
        IntStream.range(0, ArmorPlus.AP_MACE_MAT_LENGTH).forEach(i -> {
            APMaceMaterial mat = APMaceMaterial.values()[i];
            maces[i] = ITEMS.register(String.format("%s_mace", mat.getName()), () -> new APMaceItem(mat, new Item.Properties().setISTER(() -> APMaceRenderer::new)));
        });
    }

    public static Set<RegistryObject<BlockItem>> registerBlockItems() {
        return ModBlocks.blocks.stream().map(block -> ITEMS.register(block.getId().func_110623_a(), () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(ArmorPlus.AP_BLOCK_GROUP)))).collect(Collectors.toSet());
    }

    public static RegistryObject<ArrowItem> registerArrow(ArrowType type) {
        return ITEMS.register(type.getItemArrowName(), () -> new APArrowItem(type));
    }

    private static Set<RegistryObject<Item>> registerArmorBases(APArmorMaterial material) {
        Stream<EquipmentSlotType> armorSlots = Arrays.stream(EquipmentSlotType.values()).filter(v -> v.func_188453_a() == EquipmentSlotType.Group.ARMOR);
        return armorSlots.map(slot -> ITEMS.register(String.format("%s_%s_base", material.getName(), Utils.getNormalizedName(slot)), () -> new APItemBase())).collect(Collectors.toSet());
    }

    static {
        ModItems.registerToolForType(SWORDS, BATTLE_AXES, PICKAXES, BOWS);
        ModItems.registerMaceForType(MACES);
    }
}

