/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.google.common.collect.ImmutableSet;
import com.sofodev.armorplus.utils.Utils;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModVillagers {
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"armorplus");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"armorplus");
    public static final RegistryObject<PointOfInterestType> EXCHANGER = ModVillagers.registerPOI("soul_exchanger", 1, 1);
    public static final RegistryObject<VillagerProfession> SOUL_EXCHANGER = ModVillagers.register("soul_exchanger", EXCHANGER, SoundEvents.field_219697_mE);

    public static RegistryObject<PointOfInterestType> registerPOI(String name, Supplier<? extends PointOfInterestType> sup) {
        return POI_TYPES.register(name, sup);
    }

    private static RegistryObject<PointOfInterestType> registerPOI(String key, int maxFreeTickets, int validRange) {
        return ModVillagers.registerPOI(key, () -> new PointOfInterestType(key, ModVillagers.getAllStates().get(), maxFreeTickets, validRange));
    }

    private static RegistryObject<PointOfInterestType> registerPOI(String key, int maxFreeTickets, Predicate<PointOfInterestType> predicate, int validRange) {
        return ModVillagers.registerPOI(key, () -> new PointOfInterestType(key, ModVillagers.getAllStates().get(), maxFreeTickets, predicate, validRange));
    }

    public static Supplier<Set<BlockState>> getAllStates() {
        return () -> ImmutableSet.copyOf((Collection)((Block)ForgeRegistries.BLOCKS.getValue(Utils.setRL("soul_box"))).func_176194_O().func_177619_a());
    }

    public static RegistryObject<VillagerProfession> register(String name, Supplier<? extends VillagerProfession> sup) {
        return PROFESSIONS.register(name, sup);
    }

    public static RegistryObject<VillagerProfession> register(String nameIn, Supplier<PointOfInterestType> pointOfInterestIn, @Nullable SoundEvent soundIn) {
        return ModVillagers.register(nameIn, pointOfInterestIn, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), soundIn);
    }

    public static RegistryObject<VillagerProfession> register(String nameIn, Supplier<PointOfInterestType> pointOfInterestIn, ImmutableSet<Item> specificItemsIn, ImmutableSet<Block> relatedWorldBlocksIn, @Nullable SoundEvent soundIn) {
        return ModVillagers.register(nameIn, () -> new VillagerProfession(nameIn, (PointOfInterestType)pointOfInterestIn.get(), specificItemsIn, relatedWorldBlocksIn, soundIn));
    }
}

