/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BaseTile
extends TileEntity {
    public BaseTile(TileEntityType<?> type) {
        super(type);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        IEnergyStorage storage;
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler handler = this.getItemHandler(side);
            if (handler != null) {
                return LazyOptional.of(() -> handler).cast();
            }
        } else if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler tank = this.getFluidHandler(side);
            if (tank != null) {
                return LazyOptional.of(() -> tank).cast();
            }
        } else if (cap == CapabilityEnergy.ENERGY && (storage = this.getEnergyStorage(side)) != null) {
            return LazyOptional.of(() -> storage).cast();
        }
        return super.getCapability(cap, side);
    }

    public IFluidHandler getFluidHandler(Direction direction) {
        return null;
    }

    public IEnergyStorage getEnergyStorage(Direction direction) {
        return null;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return null;
    }
}

