/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.blocks.castle;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class StoneBrickSlabBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.field_208145_at;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public StoneBrickSlabBlock(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)state.func_177229_b(TYPE);
        switch (slabtype) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        if (blockstate.func_203425_a((Block)this)) {
            return (BlockState)((BlockState)blockstate.func_206870_a(TYPE, (Comparable)SlabType.DOUBLE)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState nextState = (BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = context.func_196000_l();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? nextState : (BlockState)nextState.func_206870_a(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack stack = useContext.func_195996_i();
        SlabType slabtype = (SlabType)state.func_177229_b(TYPE);
        if (slabtype != SlabType.DOUBLE && stack.func_77973_b() == this.func_199767_j()) {
            if (useContext.func_196012_c()) {
                boolean flag = useContext.func_221532_j().field_72448_b - (double)useContext.func_195995_a().func_177956_o() > 0.5;
                Direction direction = useContext.func_196000_l();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.func_176740_k().func_176722_c();
                }
                return direction == Direction.DOWN || !flag && direction.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE && super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE && super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
        }
        return false;
    }
}

