/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.blocks.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sofodev.armorplus.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractInfuserTile
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int infusionTime;
    private int recipesUsed;
    private int infusingTime;
    private int totalInfusingTime;
    protected final IIntArray infuserData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractInfuserTile.this.infusionTime;
                }
                case 1: {
                    return AbstractInfuserTile.this.recipesUsed;
                }
                case 2: {
                    return AbstractInfuserTile.this.infusingTime;
                }
                case 3: {
                    return AbstractInfuserTile.this.totalInfusingTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractInfuserTile.this.infusionTime = value;
                    break;
                }
                case 1: {
                    AbstractInfuserTile.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    AbstractInfuserTile.this.infusingTime = value;
                    break;
                }
                case 3: {
                    AbstractInfuserTile.this.totalInfusingTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Map<ResourceLocation, Integer> itemInfusionList = Maps.newHashMap();
    protected final IRecipeType<? extends AbstractCookingRecipe> recipeType;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractInfuserTile(TileEntityType<?> tileTypeIn, IRecipeType<? extends AbstractCookingRecipe> recipeTypeIn) {
        super(tileTypeIn);
        this.recipeType = recipeTypeIn;
    }

    public static Map<Item, Integer> getInfusionTimes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractInfuserTile.addItemInfuseTime((Map<Item, Integer>)map, (IItemProvider)Items.field_151129_at, 20000);
        AbstractInfuserTile.addItemInfuseTime((Map<Item, Integer>)map, ModItems.LAVA_CRYSTAL, 22000);
        AbstractInfuserTile.addItemInfuseTime((Map<Item, Integer>)map, ModItems.INFUSED_LAVA_CRYSTAL, 24000);
        return map;
    }

    private static void addItemTagBurnTime(Map<Item, Integer> map, Tag<Item> itemTag, int infusionTime) {
        itemTag.func_230236_b_().forEach(item -> map.put((Item)item, infusionTime));
    }

    private static void addItemInfuseTime(Map<Item, Integer> map, IItemProvider itemProvider, int infusionTime) {
        map.put(itemProvider.func_199767_j(), infusionTime);
    }

    private static void addItemInfuseTime(Map<Item, Integer> map, RegistryObject<Item> registryObject, int infusionTime) {
        map.put((Item)registryObject.get(), infusionTime);
    }

    private boolean isInfusing() {
        return this.infusionTime > 0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.infusionTime = nbt.func_74762_e("InfusionTime");
        this.infusingTime = nbt.func_74762_e("InfusingTime");
        this.totalInfusingTime = nbt.func_74762_e("InfusingTimeTotal");
        this.recipesUsed = this.getInfusionTime((ItemStack)this.items.get(1));
        int i = nbt.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(nbt.func_74779_i("RecipeLocation" + j));
            int k = nbt.func_74762_e("RecipeAmount" + j);
            this.itemInfusionList.put(resourcelocation, k);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("InfusionTime", this.infusionTime);
        nbt.func_74768_a("InfusingTime", this.infusingTime);
        nbt.func_74768_a("InfusingTimeTotal", this.totalInfusingTime);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
        nbt.func_74777_a("RecipesUsedSize", (short)this.itemInfusionList.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.itemInfusionList.entrySet()) {
            nbt.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            nbt.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return nbt;
    }

    public void func_73660_a() {
        boolean flag = this.isInfusing();
        boolean flag1 = false;
        if (this.isInfusing()) {
            --this.infusionTime;
        }
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.items.get(1);
            if (this.isInfusing() || !itemstack.func_190926_b() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isInfusing() && this.canSmelt(irecipe)) {
                    this.recipesUsed = this.infusionTime = this.getInfusionTime(itemstack);
                    if (this.isInfusing()) {
                        flag1 = true;
                        if (itemstack.hasContainerItem()) {
                            this.items.set(1, (Object)itemstack.getContainerItem());
                        } else if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                this.items.set(1, (Object)itemstack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isInfusing() && this.canSmelt(irecipe)) {
                    ++this.infusingTime;
                    if (this.infusingTime == this.totalInfusingTime) {
                        this.infusingTime = 0;
                        this.totalInfusingTime = this.totalInfusingTime();
                        this.getInfusionRecipe(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.infusingTime = 0;
                }
            } else if (!this.isInfusing() && this.infusingTime > 0) {
                this.infusingTime = MathHelper.func_76125_a((int)(this.infusingTime - 2), (int)0, (int)this.totalInfusingTime);
            }
            if (flag != this.isInfusing()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isInfusing())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    protected boolean canSmelt(@Nullable IRecipe<?> recipeIn) {
        if (!((ItemStack)this.items.get(0)).func_190926_b() && recipeIn != null) {
            ItemStack itemstack = recipeIn.func_77571_b();
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(2);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void getInfusionRecipe(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = recipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)this.items.get(2);
            if (itemstack2.func_190926_b()) {
                this.items.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.items.get(1)).func_190926_b() && ((ItemStack)this.items.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.items.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    protected int getInfusionTime(ItemStack stack) {
        return stack.func_190926_b() ? 0 : stack.getBurnTime();
    }

    protected int totalInfusingTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200);
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151133_ar;
        }
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        return this.items.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalInfusingTime = this.totalInfusingTime();
            this.infusingTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return AbstractInfuserTile.isFuel(stack) || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.itemInfusionList.compute(recipe.func_199560_c(), (rl, value) -> 1 + (value == null ? 0 : value));
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity player) {
    }

    public void noNameForThisYet(PlayerEntity player) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.itemInfusionList.entrySet()) {
            player.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                AbstractInfuserTile.giveExperience(player, (Integer)entry.getValue(), ((AbstractCookingRecipe)recipe).func_222138_b());
            });
        }
        player.func_195065_a((Collection)list);
        this.itemInfusionList.clear();
    }

    private static void giveExperience(PlayerEntity player, int expValue, float infusionTime) {
        if (infusionTime == 0.0f) {
            expValue = 0;
        } else if (infusionTime < 1.0f) {
            int i = MathHelper.func_76141_d((float)((float)expValue * infusionTime));
            if (i < MathHelper.func_76123_f((float)((float)expValue * infusionTime)) && Math.random() < (double)((float)expValue * infusionTime - (float)i)) {
                ++i;
            }
            expValue = i;
        }
        while (expValue > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)expValue);
            expValue -= j;
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        this.items.forEach(arg_0 -> ((RecipeItemHelper)helper).func_194112_a(arg_0));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

