/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.blocks.special;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.ModBlocks;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class TrophyTile
extends TileEntity {
    public WeightedSpawnerEntity entityData = new WeightedSpawnerEntity();
    @Nullable
    private Entity displayEntity;
    private float scale = 0.2f;

    public TrophyTile() {
        super((TileEntityType)ModBlocks.TROPHY_TYPE.get());
    }

    @Nullable
    private ResourceLocation getEntityId() {
        String id = this.entityData.func_185277_b().func_74779_i("id");
        try {
            return StringUtils.func_151246_b((String)id) ? null : new ResourceLocation(id);
        }
        catch (ResourceLocationException resourcelocationexception) {
            BlockPos pos = this.func_174877_v();
            ArmorPlus.LOGGER.warn("Invalid entity id '{}' at trophy {}:[{},{},{}]", (Object)id, (Object)this.func_145831_w().func_234923_W_().func_240901_a_(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            return null;
        }
    }

    public void setEntityId(EntityType<?> type) {
        this.entityData.func_185277_b().func_74778_a("id", ForgeRegistries.ENTITIES.getKey(type).toString());
        this.sendBlockUpdate();
    }

    public float getEntityScale() {
        return this.scale;
    }

    public void setEntityScale(float scale) {
        this.scale = scale;
        this.sendBlockUpdate();
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_150297_b("DisplayEntity", 10)) {
            this.setNextEntityData(new WeightedSpawnerEntity(1, tag.func_74775_l("DisplayEntity")));
        }
        if (tag.func_150297_b("EntityScale", 99)) {
            this.scale = tag.func_74760_g("EntityScale");
        }
        if (this.func_145831_w() != null) {
            ResourceLocation rl = new ResourceLocation(tag.func_74775_l("DisplayEntity").func_74779_i("id"));
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(rl);
            this.displayEntity = type != null ? type.func_200721_a(this.func_145831_w()) : null;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ResourceLocation resourcelocation = this.getEntityId();
        if (resourcelocation != null) {
            tag.func_74776_a("EntityScale", this.scale);
            tag.func_218657_a("DisplayEntity", (INBT)this.entityData.func_185277_b().func_74737_b());
        }
        return tag;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Entity getDisplayEntity() {
        if (this.displayEntity == null) {
            this.displayEntity = EntityType.func_220335_a((CompoundNBT)this.entityData.func_185277_b(), (World)this.func_145831_w(), Function.identity());
            if (this.entityData.func_185277_b().func_186856_d() == 1) {
                this.entityData.func_185277_b().func_150297_b("id", 8);
            }
        }
        return this.displayEntity;
    }

    @Nullable
    public World func_145831_w() {
        return super.func_145831_w();
    }

    public BlockPos func_174877_v() {
        return super.func_174877_v();
    }

    public void setNextEntityData(WeightedSpawnerEntity data) {
        this.entityData = data;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -20, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public boolean func_183000_F() {
        return false;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
    }

    public boolean func_145842_c(int id, int type) {
        return super.func_145842_c(id, type);
    }

    public void sendBlockUpdate() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
    }
}

