/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.enchantments;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.enchantments.APEnchantment;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class SoulHardenEnchantment
extends APEnchantment {
    public SoulHardenEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.WEARABLE, new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET}, 1, 1, 30, 60, true, true);
    }

    public static boolean areAllCompatible(List<Boolean> array) {
        for (boolean b : array) {
            if (b) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean func_77326_a(Enchantment ench) {
        List<Boolean> compatibilityList = ArmorPlusConfig.enchantsThatWontWorkWithSoulHarden.get().stream().filter(enchant -> Objects.requireNonNull(ench.getRegistryName()).toString().equals(enchant)).map(enchant -> false).collect(Collectors.toList());
        return SoulHardenEnchantment.areAllCompatible(compatibilityList) && super.func_77326_a(ench);
    }

    @Override
    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentType.ARMOR.func_77557_a(stack.func_77973_b());
    }

    public boolean func_190936_d() {
        return false;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isAllowedOnBooks() {
        return true;
    }
}

