/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.arrows;

import com.sofodev.armorplus.registry.entities.arrows.ArrowProperty;
import com.sofodev.armorplus.utils.Utils;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class APArrowEntity
extends AbstractArrowEntity {
    private EntityType<? extends APArrowEntity> type;
    private ArrowProperty prop;

    public APArrowEntity(EntityType<? extends APArrowEntity> type, World world) {
        super(type, world);
        this.type = type;
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, World world, ArrowProperty property) {
        super(type, world);
        this.type = type;
        this.setProp(property);
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, double x, double y, double z, World world, ArrowProperty property) {
        super(type, x, y, z, world);
        this.type = type;
        this.setProp(property);
        this.func_70107_b(x, y, z);
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, LivingEntity shooter, World world, ArrowProperty property) {
        super(type, shooter, world);
        this.type = type;
        this.setProp(property);
        this.func_212361_a((Entity)shooter);
        if (shooter instanceof PlayerEntity) {
            this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        }
    }

    public APArrowEntity(EntityType<? extends APArrowEntity> type, FMLPlayMessages.SpawnEntity packet, World world, ArrowProperty property) {
        this(type, packet.getPosX(), packet.getPosY(), packet.getPosZ(), world, property);
        this.type = type;
        this.func_70101_b(packet.getHeadYaw(), packet.getPitch());
        this.func_184221_a(packet.getUuid());
        this.func_145769_d(packet.getEntityId());
        this.func_213293_j(packet.getVelX(), packet.getVelY(), packet.getVelZ());
    }

    public APArrowEntity setProp(ArrowProperty prop) {
        this.prop = prop;
        return this;
    }

    public ArrowProperty getProp() {
        return this.prop;
    }

    public void func_70239_b(double damageIn) {
        super.func_70239_b(this.prop.getDmg());
    }

    public double func_70242_d() {
        return super.func_70242_d();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getProp());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected ItemStack func_184550_j() {
        ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(Utils.setRL(this.prop.getName() + "_arrow")));
        return stack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151032_g) : stack;
    }

    public EntityType<?> func_200600_R() {
        return this.type;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_184548_a(LivingEntity target) {
        super.func_184548_a(target);
        if (!this.field_70170_p.field_72995_K && target != this.getEntity()) {
            this.prop.hit(target);
        }
    }
}

