/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.arrows;

import com.sofodev.armorplus.registry.ModPotions;
import com.sofodev.armorplus.registry.entities.arrows.IArrow;
import com.sofodev.armorplus.registry.items.extras.EffectData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;

public class ArrowProperty
implements IArrow {
    private final String name;
    private final IParticleData particleType;
    private final double dmg;
    private final EffectData data;

    public ArrowProperty(String name, double dmg, IParticleData particleType, EffectData data) {
        this.name = name;
        this.dmg = dmg;
        this.particleType = particleType;
        this.data = data;
    }

    public ArrowProperty(String name, double dmg, IParticleData particleType) {
        this(name, dmg, particleType, new EffectData((Effect)ModPotions.EMPTY.get()));
    }

    public static ArrowProperty create(String name, double dmg, IParticleData particle, EffectData data) {
        return new ArrowProperty(name, dmg, particle, data);
    }

    public static ArrowProperty create(String name, double dmg, IParticleData particle) {
        return new ArrowProperty(name, dmg, particle, new EffectData((Effect)ModPotions.EMPTY.get()));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public double getDmg() {
        return this.dmg;
    }

    @Override
    public IParticleData getParticle() {
        return this.particleType;
    }

    @Override
    public EffectData getData() {
        return this.data;
    }

    @Override
    public IArrow hit(LivingEntity living) {
        EffectData effData = this.getData();
        Effect eff = effData.getEffect();
        if (eff != null) {
            living.func_195064_c(new EffectInstance(eff, effData.getDuration(), effData.getAmplifier()));
        }
        return this;
    }

    public String toString() {
        return "ArrowProperty{name='" + this.name + '\'' + ", particleType=" + this.particleType + ", dmg=" + this.dmg + ", data=" + this.data + '}';
    }
}

