/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses;

import com.google.common.collect.Lists;
import com.sofodev.armorplus.registry.entities.bosses.extras.SpecificRangedAttackGoal;
import com.sofodev.armorplus.registry.entities.bosses.extras.SpecificServerBossInfo;
import com.sofodev.armorplus.registry.entities.bosses.manager.DragonFightManager;
import com.sofodev.armorplus.registry.entities.bosses.manager.IPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseManager;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DemonicDragonEntity
extends MonsterEntity
implements IRangedAttackMob,
IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(DemonicDragonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final SpecificServerBossInfo bossInfo = new SpecificServerBossInfo(this.func_145748_c_(), SpecificServerBossInfo.BossInfoDungeonType.DEMONIC_DRAGON);
    public float rotationYaw = 1.0f;
    @Nullable
    private final DragonFightManager dragonFight;
    private final PhaseManager phaseManager;
    private final PathPoint[] nodes = new PathPoint[24];
    private final int[] nodeAdjacency = new int[24];
    private final PathHeap openSet = new PathHeap();

    public DemonicDragonEntity(EntityType<? extends DemonicDragonEntity> type, World world) {
        super(type, world);
        this.func_110163_bv();
        this.func_70606_j(this.func_110138_aP());
        this.field_70158_ak = true;
        this.func_213323_x_();
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            MinecraftServer server = serverWorld.func_73046_m();
            IServerConfiguration configuration = server.func_240793_aU_();
            this.dragonFight = new DragonFightManager(serverWorld, configuration.func_230418_z_().func_236221_b_(), configuration.func_230402_B_());
        } else {
            this.dragonFight = null;
        }
        this.phaseManager = new PhaseManager(this);
    }

    public EntitySize func_213305_a(Pose pose) {
        return EntitySize.func_220314_b((float)4.0f, (float)4.0f).func_220312_a(1.0f, 1.0f);
    }

    public void func_70623_bb() {
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 6.0f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new SpecificRangedAttackGoal(this, SpecificRangedAttackGoal.EntityAIType.GUARDIAN));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 1024.0).func_233815_a_(Attributes.field_233821_d_, 1.0).func_233815_a_(Attributes.field_233826_i_, 8.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PHASE, (Object)PhaseType.HOVER.getId());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof WitherEntity)) {
            Entity entity = source.func_76364_f();
            if (entity instanceof AbstractArrowEntity) {
                return false;
            }
            Entity trueSource = source.func_76346_g();
            if (trueSource != null && !(trueSource instanceof PlayerEntity) && trueSource instanceof LivingEntity && ((LivingEntity)trueSource).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            return super.func_70097_a(source, damage);
        }
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        if (compound.func_74764_b("DragonPhase")) {
            this.phaseManager.setPhase(PhaseType.getById(compound.func_74762_e("DragonPhase")));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DragonPhase", this.phaseManager.getCurrentPhase().getPhase().getId());
    }

    public boolean func_241845_aY() {
        return true;
    }

    public ITextComponent func_200201_e() {
        return new StringTextComponent("Demonic Dragon");
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_213385_F() {
        super.func_213385_F();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public DragonFightManager getDragonFight() {
        return this.dragonFight;
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = MathHelper.func_76141_d((float)(60.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                    i1 = MathHelper.func_76141_d((float)(60.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                } else if (i < 20) {
                    int lvt_3_1_ = i - 12;
                    l = MathHelper.func_76141_d((float)(40.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_)))));
                    i1 = MathHelper.func_76141_d((float)(40.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_)))));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = MathHelper.func_76141_d((float)(20.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                    i1 = MathHelper.func_76141_d((float)(20.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                }
                int j1 = Math.max(this.field_70170_p.func_181545_F() + 10, this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).func_177956_o() + j);
                this.nodes[i] = new PathPoint(l, j1, i1);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public int findClosestNode(double p_184663_1_, double p_184663_3_, double p_184663_5_) {
        float f = 10000.0f;
        int i = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.func_76128_c((double)p_184663_1_), MathHelper.func_76128_c((double)p_184663_3_), MathHelper.func_76128_c((double)p_184663_5_));
        int j = 0;
        if (this.dragonFight == null) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.nodes[k] == null || !((f1 = this.nodes[k].func_75832_b(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @Nullable
    public Path findPath(int p_184666_1_, int p_184666_2_, @Nullable PathPoint p_184666_3_) {
        for (int i = 0; i < 24; ++i) {
            PathPoint pathpoint = this.nodes[i];
            pathpoint.field_75842_i = false;
            pathpoint.field_75834_g = 0.0f;
            pathpoint.field_75836_e = 0.0f;
            pathpoint.field_75833_f = 0.0f;
            pathpoint.field_75841_h = null;
            pathpoint.field_75835_d = -1;
        }
        PathPoint pathpoint4 = this.nodes[p_184666_1_];
        PathPoint pathpoint5 = this.nodes[p_184666_2_];
        pathpoint4.field_75836_e = 0.0f;
        pathpoint4.field_75834_g = pathpoint4.field_75833_f = pathpoint4.func_75829_a(pathpoint5);
        this.openSet.func_75848_a();
        this.openSet.func_75849_a(pathpoint4);
        PathPoint pathpoint1 = pathpoint4;
        int j = 0;
        if (this.dragonFight == null) {
            j = 12;
        }
        while (!this.openSet.func_75845_e()) {
            PathPoint pathpoint2 = this.openSet.func_75844_c();
            if (pathpoint2.equals((Object)pathpoint5)) {
                if (p_184666_3_ != null) {
                    p_184666_3_.field_75841_h = pathpoint5;
                    pathpoint5 = p_184666_3_;
                }
                return this.reconstructPath(pathpoint4, pathpoint5);
            }
            if (pathpoint2.func_75829_a(pathpoint5) < pathpoint1.func_75829_a(pathpoint5)) {
                pathpoint1 = pathpoint2;
            }
            pathpoint2.field_75842_i = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.nodes[l] != pathpoint2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.nodeAdjacency[k] & 1 << i1) <= 0) continue;
                PathPoint pathpoint3 = this.nodes[i1];
                if (pathpoint3.field_75842_i) continue;
                float f = pathpoint2.field_75836_e + pathpoint2.func_75829_a(pathpoint3);
                if (pathpoint3.func_75831_a() && !(f < pathpoint3.field_75836_e)) continue;
                pathpoint3.field_75841_h = pathpoint2;
                pathpoint3.field_75836_e = f;
                pathpoint3.field_75833_f = pathpoint3.func_75829_a(pathpoint5);
                if (pathpoint3.func_75831_a()) {
                    this.openSet.func_75850_a(pathpoint3, pathpoint3.field_75836_e + pathpoint3.field_75833_f);
                    continue;
                }
                pathpoint3.field_75834_g = pathpoint3.field_75836_e + pathpoint3.field_75833_f;
                this.openSet.func_75849_a(pathpoint3);
            }
        }
        if (pathpoint1 == pathpoint4) {
            return null;
        }
        field_184243_a.debug("Failed to find path from {} to {}", (Object)p_184666_1_, (Object)p_184666_2_);
        if (p_184666_3_ != null) {
            p_184666_3_.field_75841_h = pathpoint1;
            pathpoint1 = p_184666_3_;
        }
        return this.reconstructPath(pathpoint4, pathpoint1);
    }

    private Path reconstructPath(PathPoint p_184669_1_, PathPoint p_184669_2_) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint = p_184669_2_;
        list.add(0, p_184669_2_);
        while (pathpoint.field_75841_h != null) {
            pathpoint = pathpoint.field_75841_h;
            list.add(0, pathpoint);
        }
        return new Path((List)list, new BlockPos(p_184669_2_.field_75839_a, p_184669_2_.field_75837_b, p_184669_2_.field_75838_c), true);
    }

    public boolean func_70067_L() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187526_aP;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadPartYOffset(int p_184667_1_, double[] p_184667_2_, double[] p_184667_3_) {
        double d0;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getPhase();
        if (phasetype != PhaseType.LANDING && phasetype != PhaseType.TAKEOFF) {
            d0 = iphase.isSitting() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : p_184667_3_[1] - p_184667_2_[1]);
        } else {
            BlockPos blockpos = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
            float f = Math.max(MathHelper.func_76133_a((double)blockpos.func_218138_a((IPosition)this.func_213303_ch(), true)) / 4.0f, 1.0f);
            d0 = (float)p_184667_1_ / f;
        }
        return (float)d0;
    }

    public Vector3d getHeadLookVector(float pos) {
        Vector3d vector3d;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getPhase();
        if (phasetype != PhaseType.LANDING && phasetype != PhaseType.TAKEOFF) {
            if (iphase.isSitting()) {
                float f4 = this.field_70125_A;
                float f5 = 1.5f;
                this.field_70125_A = -45.0f;
                vector3d = this.func_70676_i(pos);
                this.field_70125_A = f4;
            } else {
                vector3d = this.func_70676_i(pos);
            }
        } else {
            BlockPos blockpos = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
            float f = Math.max(MathHelper.func_76133_a((double)blockpos.func_218138_a((IPosition)this.func_213303_ch(), true)) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.field_70125_A;
            float f3 = 1.5f;
            this.field_70125_A = -f1 * 1.5f * 5.0f;
            vector3d = this.func_70676_i(pos);
            this.field_70125_A = f2;
        }
        return vector3d;
    }

    public void func_184206_a(DataParameter<?> phase) {
        if (PHASE.equals(phase) && this.field_70170_p.field_72995_K) {
            this.phaseManager.setPhase(PhaseType.getById((Integer)this.func_184212_Q().func_187225_a(PHASE)));
        }
        super.func_184206_a(phase);
    }

    public boolean func_195064_c(EffectInstance instance) {
        return false;
    }

    protected boolean func_184228_n(Entity entity) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
    }
}

