/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses.manager;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.sofodev.armorplus.registry.ModEntities;
import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.manager.DragonSpawnState;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.EndSpikeFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonFightManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<Entity> VALID_PLAYER = EntityPredicates.field_94557_a.and(EntityPredicates.func_188443_a((double)0.0, (double)128.0, (double)0.0, (double)192.0));
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo((ITextComponent)new TranslationTextComponent("entity.armorplus.demonic_dragon"), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private final ServerWorld world;
    private final List<Integer> gateways = Lists.newArrayList();
    private final BlockPattern portalPattern;
    private int ticksSinceDragonSeen;
    private int aliveCrystals;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan;
    private boolean dragonKilled;
    private boolean previouslyKilled;
    private UUID dragonUniqueId;
    private boolean scanForLegacyFight = true;
    private BlockPos exitPortalLocation;
    private DragonSpawnState respawnState;
    private int respawnStateTicks;
    private List<EnderCrystalEntity> crystals;

    public DragonFightManager(ServerWorld world, long seed, CompoundNBT dragonFightNBT) {
        this.world = world;
        if (dragonFightNBT.func_150297_b("DragonKilled", 99)) {
            if (dragonFightNBT.func_186855_b("Dragon")) {
                this.dragonUniqueId = dragonFightNBT.func_186857_a("Dragon");
            }
            this.dragonKilled = dragonFightNBT.func_74767_n("DragonKilled");
            this.previouslyKilled = dragonFightNBT.func_74767_n("PreviouslyKilled");
            boolean bl = this.scanForLegacyFight = !dragonFightNBT.func_74767_n("LegacyScanPerformed");
            if (dragonFightNBT.func_74767_n("IsRespawning")) {
                this.respawnState = DragonSpawnState.START;
            }
            if (dragonFightNBT.func_150297_b("ExitPortalLocation", 10)) {
                this.exitPortalLocation = NBTUtil.func_186861_c((CompoundNBT)dragonFightNBT.func_74775_l("ExitPortalLocation"));
            }
        } else {
            this.dragonKilled = true;
            this.previouslyKilled = true;
        }
        if (dragonFightNBT.func_150297_b("Gateways", 9)) {
            ListNBT listnbt = dragonFightNBT.func_150295_c("Gateways", 3);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.gateways.add(listnbt.func_186858_c(i));
            }
        } else {
            this.gateways.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.gateways, new Random(seed));
        }
        this.portalPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  "}).func_177659_a(new String[]{"       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       "}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150357_h))).func_177661_b();
    }

    public CompoundNBT write() {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (this.dragonUniqueId != null) {
            compoundnbt.func_186854_a("Dragon", this.dragonUniqueId);
        }
        compoundnbt.func_74757_a("DragonKilled", this.dragonKilled);
        compoundnbt.func_74757_a("PreviouslyKilled", this.previouslyKilled);
        compoundnbt.func_74757_a("LegacyScanPerformed", !this.scanForLegacyFight);
        if (this.exitPortalLocation != null) {
            compoundnbt.func_218657_a("ExitPortalLocation", (INBT)NBTUtil.func_186859_a((BlockPos)this.exitPortalLocation));
        }
        ListNBT listnbt = new ListNBT();
        for (int i : this.gateways) {
            listnbt.add((Object)IntNBT.func_229692_a_((int)i));
        }
        compoundnbt.func_218657_a("Gateways", (INBT)listnbt);
        return compoundnbt;
    }

    public void tick() {
        this.bossInfo.func_186758_d(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.bossInfo.func_186757_c().isEmpty()) {
            this.world.func_72863_F().registerTickingTicket(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean flag = this.isFightAreaLoaded();
            if (this.scanForLegacyFight && flag) {
                this.scanForLegacyFight();
                this.scanForLegacyFight = false;
            }
            if (this.respawnState != null) {
                if (this.crystals == null && flag) {
                    this.respawnState = null;
                    this.tryRespawnDragon();
                }
                this.respawnState.process(this.world, this, this.crystals, this.respawnStateTicks++, this.exitPortalLocation);
            }
            if (!this.dragonKilled) {
                if ((this.dragonUniqueId == null || ++this.ticksSinceDragonSeen >= 1200) && flag) {
                    this.findOrCreateDragon();
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && flag) {
                    this.findAliveCrystals();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            this.world.func_72863_F().releaseTickingTicket(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
    }

    private void scanForLegacyFight() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean wasPreviouslyKilled = this.exitPortalExists();
        if (wasPreviouslyKilled) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.previouslyKilled = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.generatePortal(false);
            }
        }
        List<DemonicDragonEntity> list = this.getDragons(this.world);
        if (list.isEmpty()) {
            this.dragonKilled = true;
        } else {
            DemonicDragonEntity demonicDragonEntity = list.get(0);
            this.dragonUniqueId = demonicDragonEntity.func_110124_au();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)demonicDragonEntity);
            this.dragonKilled = false;
            if (!wasPreviouslyKilled) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                demonicDragonEntity.func_70106_y();
                this.dragonUniqueId = null;
            }
        }
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    private void findOrCreateDragon() {
        List list = this.world.func_217439_j();
        if (list.isEmpty()) {
            LOGGER.debug("Haven't seen the dragon, respawning it");
            this.createNewDragon();
        } else {
            LOGGER.debug("Haven't seen our dragon, but found another one to use.");
            this.dragonUniqueId = ((EnderDragonEntity)list.get(0)).func_110124_au();
        }
    }

    protected void setRespawnState(DragonSpawnState state) {
        if (this.respawnState == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnStateTicks = 0;
        if (state == DragonSpawnState.END) {
            this.respawnState = null;
            this.dragonKilled = false;
            DemonicDragonEntity demonicDragonEntity = this.createNewDragon();
            for (ServerPlayerEntity serverplayerentity : this.bossInfo.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)demonicDragonEntity);
            }
        } else {
            this.respawnState = state;
        }
    }

    private boolean exitPortalExists() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.world.func_212866_a_(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    if (!(tileentity instanceof EndPortalTileEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper findExitPortal() {
        int k;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.world.func_212866_a_(i, j);
                for (TileEntity blockEntity : chunk.func_177434_r().values()) {
                    BlockPattern.PatternHelper blockpattern$patternhelper;
                    if (!(blockEntity instanceof EndPortalTileEntity) || (blockpattern$patternhelper = this.portalPattern.func_177681_a((IWorldReader)this.world, blockEntity.func_174877_v())) == null) continue;
                    BlockPos blockpos = blockpattern$patternhelper.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.exitPortalLocation == null && blockpos.func_177958_n() == 0 && blockpos.func_177952_p() == 0) {
                        this.exitPortalLocation = blockpos;
                    }
                    return blockpattern$patternhelper;
                }
            }
        }
        for (int l = k = this.world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a).func_177956_o(); l >= 0; --l) {
            BlockPattern.PatternHelper blockpattern$patternhelper1 = this.portalPattern.func_177681_a((IWorldReader)this.world, new BlockPos(EndPodiumFeature.field_186139_a.func_177958_n(), l, EndPodiumFeature.field_186139_a.func_177952_p()));
            if (blockpattern$patternhelper1 == null) continue;
            if (this.exitPortalLocation == null) {
                this.exitPortalLocation = blockpattern$patternhelper1.func_177670_a(3, 3, 3).func_177508_d();
            }
            return blockpattern$patternhelper1;
        }
        return null;
    }

    private boolean isFightAreaLoaded() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = 8; j <= 8; ++j) {
                IChunk ichunk = this.world.func_217353_a(i, j, ChunkStatus.field_222617_m, false);
                if (!(ichunk instanceof Chunk)) {
                    return false;
                }
                ChunkHolder.LocationType chunkholder$locationtype = ((Chunk)ichunk).func_217321_u();
                if (chunkholder$locationtype.func_219065_a(ChunkHolder.LocationType.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayerEntity serverplayerentity : this.world.func_217490_a(VALID_PLAYER)) {
            this.bossInfo.func_186760_a(serverplayerentity);
            set.add(serverplayerentity);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.bossInfo.func_186757_c());
        set1.removeAll(set);
        for (ServerPlayerEntity serverplayerentity1 : set1) {
            this.bossInfo.func_186761_b(serverplayerentity1);
        }
    }

    private void findAliveCrystals() {
        this.ticksSinceCrystalsScanned = 0;
        this.aliveCrystals = 0;
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_236356_a_((ISeedReader)this.world)) {
            this.aliveCrystals += this.world.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", (Object)this.aliveCrystals);
    }

    public void processDragonDeath(EnderDragonEntity dragon) {
        if (dragon.func_110124_au().equals(this.dragonUniqueId)) {
            this.bossInfo.func_186735_a(0.0f);
            this.bossInfo.func_186758_d(false);
            this.generatePortal(true);
            this.spawnNewGateway();
            if (!this.previouslyKilled) {
                this.world.func_175656_a(this.world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a), Blocks.field_150380_bt.func_176223_P());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    private void spawnNewGateway() {
        if (!this.gateways.isEmpty()) {
            int i = this.gateways.remove(this.gateways.size() - 1);
            int j = MathHelper.func_76128_c((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            int k = MathHelper.func_76128_c((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            this.generateGateway(new BlockPos(j, 75, k));
        }
    }

    private void generateGateway(BlockPos pos) {
        this.world.func_217379_c(3000, pos, 0);
        Features.field_243907_c.func_242765_a((ISeedReader)this.world, this.world.func_72863_F().func_201711_g(), new Random(), pos);
    }

    private void generatePortal(boolean active) {
        EndPodiumFeature endpodiumfeature = new EndPodiumFeature(active);
        if (this.exitPortalLocation == null) {
            this.exitPortalLocation = this.world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a).func_177977_b();
            while (this.world.func_180495_p(this.exitPortalLocation).func_203425_a(Blocks.field_150357_h) && this.exitPortalLocation.func_177956_o() > this.world.func_181545_F()) {
                this.exitPortalLocation = this.exitPortalLocation.func_177977_b();
            }
        }
        endpodiumfeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242765_a((ISeedReader)this.world, this.world.func_72863_F().func_201711_g(), new Random(), this.exitPortalLocation);
    }

    private DemonicDragonEntity createNewDragon() {
        this.world.func_175726_f(new BlockPos(0, 128, 0));
        DemonicDragonEntity demonicDragonEntity = (DemonicDragonEntity)((EntityType)ModEntities.DEMONIC_DRAGON.get()).func_200721_a((World)this.world);
        demonicDragonEntity.getPhaseManager().setPhase(PhaseType.HOLDING_PATTERN);
        this.world.func_217376_c((Entity)demonicDragonEntity);
        this.dragonUniqueId = demonicDragonEntity.func_110124_au();
        return demonicDragonEntity;
    }

    public void dragonUpdate(EnderDragonEntity dragonIn) {
        if (dragonIn.func_110124_au().equals(this.dragonUniqueId)) {
            this.bossInfo.func_186735_a(dragonIn.func_110143_aJ() / dragonIn.func_110138_aP());
            this.ticksSinceDragonSeen = 0;
            if (dragonIn.func_145818_k_()) {
                this.bossInfo.func_186739_a(dragonIn.func_145748_c_());
            }
        }
    }

    public int getNumAliveCrystals() {
        return this.aliveCrystals;
    }

    public void onCrystalDestroyed(EnderCrystalEntity crystal, DamageSource dmgSrc) {
        if (this.respawnState != null && this.crystals.contains(crystal)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnState = null;
            this.respawnStateTicks = 0;
            this.resetSpikeCrystals();
            this.generatePortal(true);
        } else {
            this.findAliveCrystals();
            Entity entity = this.world.func_217461_a(this.dragonUniqueId);
            if (entity instanceof EnderDragonEntity) {
                ((EnderDragonEntity)entity).func_184672_a(crystal, crystal.func_233580_cy_(), dmgSrc);
            }
        }
    }

    public boolean hasPreviouslyKilledDragon() {
        return this.previouslyKilled;
    }

    public void tryRespawnDragon() {
        if (this.dragonKilled && this.respawnState == null) {
            BlockPos blockpos = this.exitPortalLocation;
            if (blockpos == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.PatternHelper blockpattern$patternhelper = this.findExitPortal();
                if (blockpattern$patternhelper == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.generatePortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & temporarily using it.");
                }
                blockpos = this.exitPortalLocation;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos blockpos1 = blockpos.func_177981_b(1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List list = this.world.func_217357_a(EnderCrystalEntity.class, new AxisAlignedBB(blockpos1.func_177967_a(direction, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.respawnDragon(list1);
        }
    }

    private void respawnDragon(List<EnderCrystalEntity> crystalsIn) {
        if (this.dragonKilled && this.respawnState == null) {
            BlockPattern.PatternHelper blockpattern$patternhelper = this.findExitPortal();
            while (blockpattern$patternhelper != null) {
                for (int i = 0; i < this.portalPattern.func_185922_a(); ++i) {
                    for (int j = 0; j < this.portalPattern.func_177685_b(); ++j) {
                        for (int k = 0; k < this.portalPattern.func_177684_c(); ++k) {
                            CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, k);
                            if (!cachedblockinfo.func_177509_a().func_203425_a(Blocks.field_150357_h) && !cachedblockinfo.func_177509_a().func_203425_a(Blocks.field_150384_bq)) continue;
                            this.world.func_175656_a(cachedblockinfo.func_177508_d(), Blocks.field_150377_bs.func_176223_P());
                        }
                    }
                }
                blockpattern$patternhelper = this.findExitPortal();
            }
            this.respawnState = DragonSpawnState.START;
            this.respawnStateTicks = 0;
            this.generatePortal(false);
            this.crystals = crystalsIn;
        }
    }

    public void resetSpikeCrystals() {
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_236356_a_((ISeedReader)this.world)) {
            for (EnderCrystalEntity endercrystalentity : this.world.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f())) {
                endercrystalentity.func_184224_h(false);
                endercrystalentity.func_184516_a((BlockPos)null);
            }
        }
    }

    public void addPlayer(ServerPlayerEntity player) {
        this.bossInfo.func_186760_a(player);
    }

    public void removePlayer(ServerPlayerEntity player) {
        this.bossInfo.func_186761_b(player);
    }

    public List<DemonicDragonEntity> getDragons(ServerWorld world) {
        ArrayList list = Lists.newArrayList();
        for (Entity entity : world.getEntities().collect(Collectors.toList())) {
            if (!(entity instanceof DemonicDragonEntity) || !entity.func_70089_S()) continue;
            list.add((DemonicDragonEntity)entity);
        }
        return list;
    }
}

