/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses.manager;

import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.manager.IPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.AttackingSittingPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.ChargingPlayerPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.DyingPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.FlamingSittingPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.HoldingPatternPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.HoverPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.LandingApproachPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.LandingPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.ScanningSittingPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.StrafePlayerPhase;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.TakeoffPhase;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class PhaseType<T extends IPhase> {
    private static PhaseType<?>[] phases = new PhaseType[0];
    public static final PhaseType<HoldingPatternPhase> HOLDING_PATTERN = PhaseType.create(HoldingPatternPhase.class, "HoldingPattern");
    public static final PhaseType<StrafePlayerPhase> STRAFE_PLAYER = PhaseType.create(StrafePlayerPhase.class, "StrafePlayer");
    public static final PhaseType<LandingApproachPhase> LANDING_APPROACH = PhaseType.create(LandingApproachPhase.class, "LandingApproach");
    public static final PhaseType<LandingPhase> LANDING = PhaseType.create(LandingPhase.class, "Landing");
    public static final PhaseType<TakeoffPhase> TAKEOFF = PhaseType.create(TakeoffPhase.class, "Takeoff");
    public static final PhaseType<FlamingSittingPhase> SITTING_FLAMING = PhaseType.create(FlamingSittingPhase.class, "SittingFlaming");
    public static final PhaseType<ScanningSittingPhase> SITTING_SCANNING = PhaseType.create(ScanningSittingPhase.class, "SittingScanning");
    public static final PhaseType<AttackingSittingPhase> SITTING_ATTACKING = PhaseType.create(AttackingSittingPhase.class, "SittingAttacking");
    public static final PhaseType<ChargingPlayerPhase> CHARGING_PLAYER = PhaseType.create(ChargingPlayerPhase.class, "ChargingPlayer");
    public static final PhaseType<DyingPhase> DYING = PhaseType.create(DyingPhase.class, "Dying");
    public static final PhaseType<HoverPhase> HOVER = PhaseType.create(HoverPhase.class, "Hover");
    private final Class<? extends IPhase> clazz;
    private final int id;
    private final String name;

    private PhaseType(int idIn, Class<? extends IPhase> clazzIn, String nameIn) {
        this.id = idIn;
        this.clazz = clazzIn;
        this.name = nameIn;
    }

    public IPhase createPhase(DemonicDragonEntity dragon) {
        try {
            Constructor<IPhase> constructor = this.getConstructor();
            return constructor.newInstance(new Object[]{dragon});
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    protected Constructor<? extends IPhase> getConstructor() throws NoSuchMethodException {
        return this.clazz.getConstructor(DemonicDragonEntity.class);
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name + " (#" + this.id + ")";
    }

    public static PhaseType<?> getById(int idIn) {
        return idIn >= 0 && idIn < phases.length ? phases[idIn] : HOLDING_PATTERN;
    }

    public static int getTotalPhases() {
        return phases.length;
    }

    private static <T extends IPhase> PhaseType<T> create(Class<T> phaseIn, String nameIn) {
        PhaseType<T> phasetype = new PhaseType<T>(phases.length, phaseIn, nameIn);
        phases = Arrays.copyOf(phases, phases.length + 1);
        PhaseType.phases[phasetype.getId()] = phasetype;
        return phasetype;
    }
}

