/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses.manager.phase;

import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseType;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.Phase;
import javax.annotation.Nullable;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChargingPlayerPhase
extends Phase {
    private static final Logger LOGGER = LogManager.getLogger();
    private Vector3d targetLocation;
    private int timeSinceCharge;

    public ChargingPlayerPhase(DemonicDragonEntity dragonIn) {
        super(dragonIn);
    }

    @Override
    public void serverTick() {
        if (this.targetLocation == null) {
            LOGGER.warn("Aborting charge player as no target was set.");
            this.dragon.getPhaseManager().setPhase(PhaseType.HOLDING_PATTERN);
        } else if (this.timeSinceCharge > 0 && this.timeSinceCharge++ >= 10) {
            this.dragon.getPhaseManager().setPhase(PhaseType.HOLDING_PATTERN);
        } else {
            double d0 = this.targetLocation.func_186679_c(this.dragon.func_226277_ct_(), this.dragon.func_226278_cu_(), this.dragon.func_226281_cx_());
            if (d0 < 100.0 || d0 > 22500.0 || this.dragon.field_70123_F || this.dragon.field_70124_G) {
                ++this.timeSinceCharge;
            }
        }
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.timeSinceCharge = 0;
    }

    public void setTarget(Vector3d p_188668_1_) {
        this.targetLocation = p_188668_1_;
    }

    @Override
    public float getMaxRiseOrFall() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<ChargingPlayerPhase> getPhase() {
        return PhaseType.CHARGING_PLAYER;
    }
}

